/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mri;

import edu.rit.image.PJGGrayImage;
import edu.rit.mri.PixelSignal;
import edu.rit.mri.SignalDataSetReader;
import edu.rit.numeric.AggregateXYSeries;
import edu.rit.numeric.Interpolation;
import edu.rit.numeric.Series;
import edu.rit.swing.DisplayableFrame;
import java.io.File;

public class SpinSignalImage {
    private SpinSignalImage() {
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 2) {
            SpinSignalImage.usage();
        }
        File file = new File(stringArray[0]);
        double d = Double.parseDouble(stringArray[1]);
        SignalDataSetReader signalDataSetReader = new SignalDataSetReader(file);
        int n = signalDataSetReader.getHeight();
        int n2 = signalDataSetReader.getWidth();
        byte[][] byArray = new byte[n][n2];
        PJGGrayImage pJGGrayImage = new PJGGrayImage(n, n2, byArray);
        Series series = signalDataSetReader.getTimeSeries();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                PixelSignal pixelSignal = signalDataSetReader.getPixelSignal(signalDataSetReader.indexFor(i, j));
                if (pixelSignal == null) continue;
                Series series2 = pixelSignal.S_measured();
                double d2 = new Interpolation(new AggregateXYSeries(series, series2)).f(d);
                pJGGrayImage.setPixel(i, j, (float)((d2 + 32768.0) / 65536.0));
            }
        }
        signalDataSetReader.close();
        new DisplayableFrame("Spin Signal, t = " + d, pJGGrayImage.getDisplayable(), 3).setVisible(true);
    }

    private static void usage() {
        System.err.println("Usage: java edu.rit.mri.SpinSignalImage <signalfile> <t>");
        System.err.println("<signalfile> = Spin signal data set file");
        System.err.println("<t> = Time (sec)");
        System.exit(1);
    }
}

