/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.draw;

import edu.rit.draw.Drawing;
import edu.rit.swing.Displayable;
import edu.rit.swing.DisplayableFrame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

class DrawingFrame
extends DisplayableFrame {
    private Drawing myDrawing;

    public DrawingFrame(Drawing drawing) {
        super(drawing);
        this.initialize(drawing);
    }

    public DrawingFrame(String string, Drawing drawing) {
        super(string, drawing);
        this.initialize(drawing);
    }

    public DrawingFrame(Drawing drawing, int n) {
        super(drawing, n);
        this.initialize(drawing);
    }

    public DrawingFrame(String string, Drawing drawing, int n) {
        super(string, drawing, n);
        this.initialize(drawing);
    }

    private void initialize(Drawing drawing) {
        if (drawing == null) {
            throw new NullPointerException("DrawingFrame(): theDrawing is null");
        }
        this.myDrawing = drawing;
        JMenuBar jMenuBar = this.getJMenuBar();
        JMenu jMenu = jMenuBar.getMenu(0);
        JMenuItem jMenuItem = new JMenuItem("Save as Drawing...", 68);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DrawingFrame.this.doSaveAsDrawing();
            }
        });
        jMenu.insert(jMenuItem, 2);
        JMenu jMenu2 = jMenuBar.getMenu(1);
        JMenuItem jMenuItem2 = new JMenuItem("Window Title...", 84);
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DrawingFrame.this.doWindowTitle();
            }
        });
        jMenu2.add(jMenuItem2);
    }

    public void display(Displayable displayable) {
        this.myDrawing = (Drawing)displayable;
        super.display(displayable);
    }

    private void doSaveAsDrawing() {
        this.saveFile(".dwg", "Serialized drawing object files", new DisplayableFrame.FileSaver(){

            public void saveFile(File file) throws IOException {
                Drawing.write(DrawingFrame.this.myDrawing, file);
            }
        });
    }

    private void doWindowTitle() {
        String string = JOptionPane.showInputDialog(this, "Window title:", this.myDrawing.getTitle());
        if (string != null) {
            this.myDrawing.setTitle(string);
            this.setTitle(string);
        }
    }
}

