/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.compbio.phyl.test;

import edu.rit.compbio.phyl.DnaSequenceList;
import edu.rit.compbio.phyl.DnaSequenceTree;
import edu.rit.compbio.phyl.FitchParsimony;
import edu.rit.compbio.phyl.JukesCantorDistance;
import edu.rit.compbio.phyl.TreeDrawing;
import edu.rit.compbio.phyl.Upgma;
import edu.rit.draw.Drawing;
import java.io.File;

public class Test04 {
    private Test04() {
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 3 || stringArray.length > 4) {
            Test04.usage();
        }
        File file = new File(stringArray[0]);
        File file2 = new File(stringArray[1]);
        File file3 = new File(stringArray[2]);
        TreeDrawing treeDrawing = new TreeDrawing();
        if (stringArray.length >= 4) {
            treeDrawing.setBranchLengthFormat(stringArray[3]);
        }
        DnaSequenceList dnaSequenceList = DnaSequenceList.read(file);
        DnaSequenceTree dnaSequenceTree = Upgma.buildTree(dnaSequenceList, new JukesCantorDistance());
        System.out.println("Score = " + FitchParsimony.computeScore(dnaSequenceTree));
        dnaSequenceTree.toList().write(file2, 70, true, false);
        treeDrawing.draw(dnaSequenceTree);
        Drawing.write(file3);
    }

    private static void usage() {
        System.err.println("Usage: java edu.rit.compbio.phyl.test.Test04 <infile> <outfile> <drawfile> [<format>]");
        System.err.println("<infile> = Input DNA sequence list file name");
        System.err.println("<outfile> = Output DNA sequence list file name");
        System.err.println("<drawfile> = Drawing file name");
        System.err.println("<format> = DecimalFormat string for branch lengths (default: \"0.00\")");
        System.exit(1);
    }
}

