/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.taxatree.utils;

import edu.msu.cme.rdp.classifier.ClassificationResult;
import edu.msu.cme.rdp.classifier.RankAssignment;
import edu.msu.cme.rdp.taxatree.ConcretRoot;
import edu.msu.cme.rdp.taxatree.Node;
import edu.msu.cme.rdp.taxatree.Taxon;
import edu.msu.cme.rdp.taxatree.TaxonHolder;
import java.util.List;

public class ClassifierTreeBuilder<E extends Taxon> {
    private ClassifierTaxonFactory<E> taxonFactory;
    private ConcretRoot<E> root;
    private float conf;
    private boolean incSeqNodes = true;

    public ClassifierTreeBuilder(E rootTaxon, List<ClassificationResult> classifications, float conf, ClassifierTaxonFactory<E> taxonFactory) {
        this(new ConcretRoot(rootTaxon), classifications, conf, taxonFactory);
    }

    public ClassifierTreeBuilder(ConcretRoot<E> root, List<ClassificationResult> classifications, float conf, ClassifierTaxonFactory<E> taxonFactory) {
        this(root, conf, taxonFactory);
        this.appendClassifications(classifications);
    }

    public ClassifierTreeBuilder(E rootTaxon, float conf, ClassifierTaxonFactory<E> taxonFactory) {
        this(new ConcretRoot(rootTaxon), conf, taxonFactory);
    }

    public ClassifierTreeBuilder(ConcretRoot<E> root, float conf, ClassifierTaxonFactory<E> taxonFactory) {
        this.root = root;
        this.taxonFactory = taxonFactory;
        this.conf = conf;
    }

    public void appendClassifications(List<ClassificationResult> classifications) {
        for (ClassificationResult result : classifications) {
            this.processAssignments(this.root.getRootTaxid(), result);
        }
    }

    public void appendClassification(ClassificationResult classification) {
        this.processAssignments(this.root.getRootTaxid(), classification);
    }

    public void setIncSeqNodes(boolean b) {
        this.incSeqNodes = b;
    }

    public void setTaxonFactory(ClassifierTaxonFactory<E> taxonFactory) {
        this.taxonFactory = taxonFactory;
    }

    private void processAssignments(int rootId, ClassificationResult result) {
        int parentId = rootId;
        for (RankAssignment assign : result.getAssignments()) {
            if (!this.createOrAddTaxon(parentId, assign)) break;
            parentId = assign.getTaxid();
        }
        if (this.incSeqNodes) {
            this.createOrAddTaxon(parentId, result.getSequence().getSeqName().hashCode(), result.getSequence().getSeqName(), "sequence", 1.0f);
        }
    }

    private boolean createOrAddTaxon(int parentId, RankAssignment assign) {
        return this.createOrAddTaxon(parentId, assign.getTaxid(), assign.getName(), assign.getRank(), assign.getConfidence());
    }

    private boolean createOrAddTaxon(int parentId, int assignTaxid, String assignName, String assignRank, float assignConf) {
        Object taxon;
        TaxonHolder parentHolder = this.root.getChild(parentId);
        if (parentHolder == null) {
            throw new IllegalStateException("Cannot find parent (taxid=" + parentId + ") when trying to add child " + assignTaxid + " " + assignName + " " + assignRank);
        }
        int taxid = assignTaxid;
        if (assignConf < this.conf) {
            taxid = Taxon.getUnclassifiedId((int)taxid);
        }
        if ((taxon = (Taxon)this.root.getChildTaxon(taxid)) == null) {
            taxon = this.taxonFactory.buildTaxon(assignTaxid, assignName, assignRank, assignConf, assignConf < this.conf);
            this.root.addChild((Node)taxon, parentId);
        }
        return assignConf > this.conf;
    }

    public ConcretRoot<E> getRoot() {
        return this.root;
    }

    public static interface ClassifierTaxonFactory<E extends Taxon> {
        public E buildTaxon(int var1, String var2, String var3, float var4, boolean var5);
    }
}

