/*
 * Decompiled with CFR 0.152.
 */
package stats.glm;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.linalg.Algebra;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import stats.glm.BasisFunction;

public class GLMClassificationModel
implements Serializable {
    static final long serialVersionUID = -7843640523256065658L;
    private List basisList;
    private DoubleMatrix1D mu;

    public GLMClassificationModel(List list, DoubleMatrix1D doubleMatrix1D) {
        this.basisList = list;
        this.mu = doubleMatrix1D;
    }

    public double positiveProbability(Object object) {
        DoubleMatrix1D doubleMatrix1D = DoubleFactory1D.dense.make(this.basisList.size());
        int n = 0;
        while (n < this.basisList.size()) {
            BasisFunction basisFunction = (BasisFunction)this.basisList.get(n);
            doubleMatrix1D.set(n, basisFunction.evaluate(object));
            ++n;
        }
        return this.logit(Algebra.DEFAULT.mult(doubleMatrix1D, this.mu));
    }

    private double logit(double d) {
        return 1.0 / (1.0 + Math.exp(-d));
    }

    public Collection getBasisFunctions() {
        return this.basisList;
    }

    public double getWeight(BasisFunction basisFunction) throws NoSuchElementException {
        int n = this.basisList.indexOf(basisFunction);
        if (n < 0) {
            throw new NoSuchElementException();
        }
        return this.mu.get(n);
    }
}

