/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.stats.svm;

import org.biojava.stats.svm.SVMKernel;

public class SigmoidKernel
implements SVMKernel {
    private double a = 1.0;
    private double c = 1.0;
    private SVMKernel kernel = null;

    public double evaluate(Object object, Object object2) {
        return this.tanh(this.getMultiplier() * this.getWrappedKernel().evaluate(object, object2) + this.getConstant());
    }

    public double getConstant() {
        return this.c;
    }

    public double getMultiplier() {
        return this.a;
    }

    public SVMKernel getWrappedKernel() {
        return this.kernel;
    }

    public void setConstant(double d) {
        this.c = d;
    }

    public void setMultiplier(double d) {
        this.a = d;
    }

    public void setWrappedKernel(SVMKernel sVMKernel) {
        this.kernel = sVMKernel;
    }

    public double tanh(double d) {
        double d2 = Math.exp(d);
        double d3 = Math.exp(-d);
        return (d2 - d3) / (d2 + d3);
    }

    public String toString() {
        return "Sigmoid kernel K(x, k) = tanh(" + this.getMultiplier() + ".k(x) + " + this.c + ")" + ". k = " + this.getWrappedKernel().toString();
    }
}

