/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.gui.sequence.BasicFeatureRenderer;
import org.biojava.bio.gui.sequence.FeatureRenderer;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.gui.sequence.SequenceRenderer;
import org.biojava.bio.gui.sequence.SequenceViewerEvent;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.PointLocation;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeForwarder;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.Changeable;
import org.biojava.utils.NestedError;

public class FeatureBlockSequenceRenderer
extends AbstractChangeable
implements SequenceRenderer {
    public static ChangeType FEATURE_RENDERER = new ChangeType("The associated FeatureRenderer has changed", "org.biojava.bio.gui.sequence.FeatureBlockSequenceRenderer", "FEATURE_RENDERER", SequenceRenderContext.LAYOUT);
    private FeatureRenderer renderer;
    private transient ChangeForwarder rendForwarder;

    public FeatureBlockSequenceRenderer() {
        try {
            this.setFeatureRenderer(new BasicFeatureRenderer());
        }
        catch (ChangeVetoException changeVetoException) {
            throw new NestedError(changeVetoException, "Assertion Failure: Should have no listeners");
        }
    }

    protected ChangeSupport getChangeSupport(ChangeType changeType) {
        ChangeSupport changeSupport = super.getChangeSupport(changeType);
        if (this.rendForwarder == null) {
            this.rendForwarder = new SequenceRenderer.RendererForwarder(this, changeSupport);
            if (this.renderer != null && this.renderer instanceof Changeable) {
                Changeable changeable = (Changeable)((Object)this.renderer);
                changeable.addChangeListener(this.rendForwarder, SequenceRenderContext.REPAINT);
            }
        }
        return changeSupport;
    }

    public double getDepth(SequenceRenderContext sequenceRenderContext, RangeLocation rangeLocation) {
        FeatureFilter.OverlapsLocation overlapsLocation;
        Sequence sequence = (Sequence)sequenceRenderContext.getSequence();
        FeatureHolder featureHolder = sequence.filter(overlapsLocation = new FeatureFilter.OverlapsLocation(rangeLocation), false);
        if (featureHolder.countFeatures() > 0) {
            return this.renderer.getDepth(sequenceRenderContext, rangeLocation);
        }
        return 0.0;
    }

    public FeatureRenderer getFeatureRenderer() {
        return this.renderer;
    }

    public double getMinimumLeader(SequenceRenderContext sequenceRenderContext, RangeLocation rangeLocation) {
        return 0.0;
    }

    public double getMinimumTrailer(SequenceRenderContext sequenceRenderContext, RangeLocation rangeLocation) {
        return 0.0;
    }

    public void paint(Graphics2D graphics2D, SequenceRenderContext sequenceRenderContext, RangeLocation rangeLocation) {
        Shape shape = graphics2D.getClip();
        Rectangle rectangle = graphics2D.getClipBounds();
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        Iterator iterator = ((Sequence)sequenceRenderContext.getSequence()).filter(new FeatureFilter.OverlapsLocation(rangeLocation), false).features();
        while (iterator.hasNext()) {
            Feature feature = (Feature)iterator.next();
            Location location = feature.getLocation();
            this.renderer.renderFeature(graphics2D, feature, sequenceRenderContext);
        }
    }

    public SequenceViewerEvent processMouseEvent(SequenceRenderContext sequenceRenderContext, MouseEvent mouseEvent, List list, RangeLocation rangeLocation) {
        list.add(this);
        int n = sequenceRenderContext.graphicsToSequence(mouseEvent.getPoint());
        FeatureHolder featureHolder = ((Sequence)sequenceRenderContext.getSequence()).filter(new FeatureFilter.OverlapsLocation(new PointLocation(n)), false);
        featureHolder = this.renderer.processMouseEvent(featureHolder, sequenceRenderContext, mouseEvent);
        return new SequenceViewerEvent(this, featureHolder, n, mouseEvent, list);
    }

    public void setFeatureRenderer(FeatureRenderer featureRenderer) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport changeSupport;
            ChangeSupport changeSupport2 = changeSupport = this.getChangeSupport(FEATURE_RENDERER);
            synchronized (changeSupport2) {
                Changeable changeable;
                ChangeEvent changeEvent = new ChangeEvent(this, FEATURE_RENDERER, this.renderer, featureRenderer);
                changeSupport.firePreChangeEvent(changeEvent);
                if (this.renderer != null && this.renderer instanceof Changeable) {
                    changeable = (Changeable)((Object)this.renderer);
                    changeable.removeChangeListener(this.rendForwarder);
                }
                this.renderer = featureRenderer;
                if (featureRenderer instanceof Changeable) {
                    changeable = (Changeable)((Object)featureRenderer);
                    changeable.removeChangeListener(this.rendForwarder);
                }
                changeSupport.firePostChangeEvent(changeEvent);
            }
        } else {
            this.renderer = featureRenderer;
        }
    }
}

