/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dp;

import java.io.Serializable;
import org.biojava.bio.BioError;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dp.AbstractTrainer;
import org.biojava.bio.dp.DP;
import org.biojava.bio.dp.EmissionState;
import org.biojava.bio.dp.IllegalTransitionException;
import org.biojava.bio.dp.MagicalState;
import org.biojava.bio.dp.MarkovModel;
import org.biojava.bio.dp.ModelTrainer;
import org.biojava.bio.dp.ScoreType;
import org.biojava.bio.dp.State;
import org.biojava.bio.dp.onehead.SingleDP;
import org.biojava.bio.dp.onehead.SingleDPMatrix;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;

public class BaumWelchSampler
extends AbstractTrainer
implements Serializable {
    public BaumWelchSampler(DP dP) {
        super(dP);
    }

    protected double singleSequenceIteration(ModelTrainer modelTrainer, SymbolList symbolList) throws IllegalSymbolException, IllegalTransitionException, IllegalAlphabetException {
        ScoreType scoreType = ScoreType.PROBABILITY;
        SingleDP singleDP = (SingleDP)this.getDP();
        State[] stateArray = singleDP.getStates();
        int[][] nArray = singleDP.getForwardTransitions();
        double[][] dArray = singleDP.getForwardTransitionScores(scoreType);
        int[][] nArray2 = singleDP.getBackwardTransitions();
        double[][] dArray2 = singleDP.getBackwardTransitionScores(scoreType);
        MarkovModel markovModel = singleDP.getModel();
        SymbolList[] symbolListArray = new SymbolList[]{symbolList};
        System.out.print("Forward... ");
        SingleDPMatrix singleDPMatrix = (SingleDPMatrix)singleDP.forwardMatrix(symbolListArray, scoreType);
        double d = singleDPMatrix.getScore();
        System.out.println("Score = " + d);
        System.out.print("Backward... ");
        SingleDPMatrix singleDPMatrix2 = (SingleDPMatrix)singleDP.backwardMatrix(symbolListArray, scoreType);
        double d2 = singleDPMatrix2.getScore();
        System.out.println("Score = " + d2);
        Symbol symbol = AlphabetManager.getGapSymbol();
        int n = 1;
        while (n <= symbolList.length()) {
            Symbol symbol2 = symbolList.symbolAt(n);
            double d3 = Math.random();
            int n2 = 0;
            while (n2 < singleDP.getDotStatesIndex()) {
                if (!(stateArray[n2] instanceof MagicalState) && (d3 -= Math.exp(singleDPMatrix.scores[n][n2] + singleDPMatrix2.scores[n][n2] - d)) <= 0.0) {
                    modelTrainer.addCount(((EmissionState)stateArray[n2]).getDistribution(), symbol2, 1.0);
                    break;
                }
                ++n2;
            }
            ++n;
        }
        int n3 = 0;
        while (n3 <= symbolList.length()) {
            Symbol symbol3 = n3 < symbolList.length() ? symbolList.symbolAt(n3 + 1) : symbol;
            int n4 = 0;
            while (n4 < stateArray.length) {
                int[] nArray3 = nArray2[n4];
                double[] dArray3 = dArray2[n4];
                double d4 = Math.random();
                Distribution distribution = markovModel.getWeights(stateArray[n4]);
                double[] dArray4 = singleDP.getEmission(symbol3, scoreType);
                int n5 = 0;
                while (n5 < nArray3.length) {
                    int n6 = nArray3[n5];
                    double d5 = 1.0;
                    if (stateArray[n6] instanceof EmissionState) {
                        d5 = Math.exp(dArray4[n6]);
                    }
                    if (d5 != 0.0 && (d4 -= Math.exp(singleDPMatrix.scores[n3][n4] + dArray3[n5] + singleDPMatrix2.scores[n3 + 1][n6] - d) * d5) <= 0.0) {
                        try {
                            modelTrainer.addCount(distribution, stateArray[n6], 1.0);
                            break;
                        }
                        catch (IllegalSymbolException illegalSymbolException) {
                            throw new BioError(illegalSymbolException, "Transition in backwardTransitions dissapeared");
                        }
                    }
                    ++n5;
                }
                ++n4;
            }
            ++n3;
        }
        return d;
    }
}

