## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----install, eval=FALSE------------------------------------------------------
# if (!requireNamespace("BiocManager", quietly = TRUE))
#     install.packages("BiocManager")
# 
# BiocManager::install("miaDash")

## ----start, message=FALSE, warning=FALSE--------------------------------------
# Import miaDash
library(miaDash)

# Launch miaDash
if (interactive()) {
  miaDash()
}

## ----screenfun, eval=!exists("SCREENSHOT"), include=FALSE---------------------
SCREENSHOT <- function(x, ...) knitr::include_graphics(x)

## ----screenplot1, echo=FALSE, out.width="100%"--------------------------------
SCREENSHOT("screenshots/dashboard.png", delay = 20)

## ----screenplot2, echo=FALSE, out.width="100%"--------------------------------
SCREENSHOT("screenshots/iSEEtree.png", delay = 20)

## ----citation-----------------------------------------------------------------
## Citation info
citation("miaDash")

## ----reproduce, echo=FALSE--------------------------------------------------------------------------------------------
# Session info
options(width = 120)
sessionInfo()

