## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(cache = TRUE, autodep = TRUE, cache.lazy = FALSE)

## ----warning=FALSE, message=FALSE---------------------------------------------
suppressMessages({
  library(SpatialExperimentIO)
  library(SpatialExperiment)
})

## ----eval=FALSE---------------------------------------------------------------
# ### DO NOT RUN. Example code.
# xepath <- "/path/to/folder"
# # Xenium as SPE, or SCE by setting `returnType = "SCE"`.
# xe_spe <- readXeniumSXE(dirName = xepath)

## ----eval=FALSE---------------------------------------------------------------
# ### DO NOT RUN. Example code.
# cospath <- "/path/to/folder"
# # CosMx as SPE, or SCE by setting `returnType = "SCE"`.
# cos_spe <- readCosmxSXE(dirName = cospath)

## ----eval=FALSE---------------------------------------------------------------
# ### DO NOT RUN. Example code.
# merpath <- "/path/to/folder"
# # MERSCOPE as SPE, or SCE by setting `returnType = "SCE"`.
# mer_spe <- readMerscopeSXE(dirName = merpath)

## ----eval=FALSE---------------------------------------------------------------
# ### DO NOT RUN. Example code.
# starpath <- "/path/to/folder"
# # STARmapPLUS as SPE, or SCE by setting `returnType = "SCE"`.
# star_spe <- readStarmapplusSXE(dirName = starpath)

## ----eval=FALSE---------------------------------------------------------------
# ### DO NOT RUN. Example code.
# seqfpath <- "/path/to/folder"
# # seqFISH as SPE, or SCE by setting `returnType = "SCE"`.
# seqf_spe <- readSeqfishSXE(dirName = merpath)

## -----------------------------------------------------------------------------
xepath <- system.file(
  file.path("extdata", "Xenium_small"),
  package = "SpatialExperimentIO")

list.files(xepath)

## ----eval=FALSE---------------------------------------------------------------
# # read the count matrix .h5 file - automatically DropletUtils::read10xCounts(type = "HDF5")
# xe_spe <- readXeniumSXE(dirName = xepath,
#                         returnType = "SPE",
#                         countMatPattern = "cell_feature_matrix.h5",
#                         metaDataPattern = "cells.parquet",
#                         coordNames = c("x_centroid", "y_centroid"),
#                         addExperimentXenium = TRUE, # set to TRUE to load experiment.xenium
#                         altExps = c("NegControlProbe", "UnassignedCodeword",
#                                     "NegControlCodeword", "antisense", "BLANK"),
#                         addParquetPaths = TRUE #, # set TRUE to load all .parquet below
#                         # ... # takes arguments as below
#                         )
# xe_spe <- addParquetPathsXenium(sxe = xe_spe,
#                                 dirName = xepath,
#                                 addTx = TRUE,
#                                 txMetaNames = "transcripts",
#                                 txPattern = "transcripts.parquet",
#                                 addCellBound = TRUE,
#                                 cellBoundMetaNames = "cell_boundaries",
#                                 cellBoundPattern = "cell_boundaries.parquet",
#                                 addNucBound = TRUE,
#                                 NucBoundMetaNames = "nucleus_boundaries",
#                                 NucBoundPattern = "nucleus_boundaries.parquet")

## -----------------------------------------------------------------------------
xe_spe <- readXeniumSXE(dirName = xepath)
xe_spe

## -----------------------------------------------------------------------------
xe_spe <- readXeniumSXE(xepath,
                        altExps = c("TestGene"),
                        addParquetPaths = TRUE,
                        addTx = FALSE)
xe_spe

## ----eval=FALSE---------------------------------------------------------------
# list.files(file.path(xepath, "cell_feature_matrix"))
# # "barcodes.tsv.gz" "features.tsv.gz" "matrix.mtx.gz"

## ----eval=FALSE---------------------------------------------------------------
# # or read the count matrix folder - automatically DropletUtils::read10xCounts(type = "sparse")
# xe_spe <- readXeniumSXE(dirName = xepath,
#                         countMatPattern = "cell_feature_matrix")

## -----------------------------------------------------------------------------
xe_sce <- readXeniumSXE(dirName = xepath, returnType = "SCE")
xe_sce

## -----------------------------------------------------------------------------
cospath <- system.file(
  file.path("extdata", "CosMx_small"),
  package = "SpatialExperimentIO")

list.files(cospath)

## ----eval=FALSE---------------------------------------------------------------
# cos_spe <- readCosmxSXE(dirName = cospath,
#                         returnType = "SPE",
#                         countMatPattern = "exprMat_file.csv",
#                         metaDataPattern = "metadata_file.csv",
#                         coordNames = c("CenterX_global_px", "CenterY_global_px"),
#                         addFovPos = TRUE, # set to TRUE to add fov position columns to colData()
#                         fovPosPattern = "fov_positions_file.csv",
#                         altExps = c("NegPrb", "Negative", "SystemControl", "FalseCode"),
#                         addParquetPaths = TRUE # , # set TRUE to add all .parquet below
#                         # ... # takes arguments as below
#                         )
# cos_spe <- addParquetPathsCosmx(sxe = cos_spe,
#                                 dirName = cospath,
#                                 addTx = TRUE,
#                                 txMetaNames = "transcripts",
#                                 txPattern = "tx_file.csv",
#                                 addPolygon = TRUE,
#                                 polygonMetaNames = "polygons",
#                                 polygonPattern = "polygons.csv")

## -----------------------------------------------------------------------------
cos_spe <- readCosmxSXE(cospath,
                        addPolygon = FALSE)
cos_spe

## -----------------------------------------------------------------------------
cos_sce <- readCosmxSXE(dirName = cospath, addPolygon = FALSE, returnType = "SCE")
cos_sce

## -----------------------------------------------------------------------------
merpath <- system.file(
  file.path("extdata", "MERSCOPE_small"),
  package = "SpatialExperimentIO")

list.files(merpath)

## -----------------------------------------------------------------------------
# mer_spe <- readMerscopeSXE(dirName = merpath, 
#                            returnType = "SPE",
#                            countMatPattern = "cell_by_gene.csv", 
#                            metaDataPattern = "cell_metadata.csv", 
#                            coordNames = c("center_x", "center_y"))

mer_spe <- readMerscopeSXE(dirName = merpath)
mer_spe

## -----------------------------------------------------------------------------
mer_sce <- readMerscopeSXE(dirName = merpath, returnType = "SCE")
mer_sce

## -----------------------------------------------------------------------------
starpath <- system.file(
  file.path("extdata", "STARmapPLUS_small"),
  package = "SpatialExperimentIO")

list.files(starpath)

## -----------------------------------------------------------------------------
# readStarmapplusSXE <- function(dirName = dirName, 
#                                returnType = "SPE",
#                                countMatPattern = "raw_expression_pd.csv", 
#                                metaDataPattern = "spatial.csv", 
#                                coordNames = c("X", "Y", "Z"))

star_spe <- readStarmapplusSXE(dirName = starpath)
star_spe

## -----------------------------------------------------------------------------
star_sce <- readStarmapplusSXE(dirName = starpath, returnType = "SCE")
star_sce

## -----------------------------------------------------------------------------
seqfpath <- system.file(
  file.path("extdata", "seqFISH_small"),
  package = "SpatialExperimentIO")

list.files(seqfpath)

## -----------------------------------------------------------------------------
# seqf_spe <- readSeqfishSXE(dirName = seqfpath, 
#                            returnType = "SPE",
#                            countMatPattern = "cell_by_gene.csv", 
#                            metaDataPattern = "cell_metadata.csv", 
#                            coordNames = c("center_x", "center_y"))

seqf_spe <- readSeqfishSXE(dirName = seqfpath)
seqf_spe

## -----------------------------------------------------------------------------
seqf_sce <- readSeqfishSXE(dirName = seqfpath, returnType = "SCE")
seqf_sce

## ----tidy = TRUE--------------------------------------------------------------
sessionInfo()

