/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.InputResource;
import htsjdk.samtools.seekablestream.SeekableFileStream;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.Lazy;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;

class FileInputResource
extends InputResource {
    final File fileResource;
    final Lazy<SeekableStream> lazySeekableStream = new Lazy<SeekableStream>(new Lazy.LazyInitializer<SeekableStream>(){

        @Override
        public SeekableStream make() {
            try {
                return new SeekableFileStream(FileInputResource.this.fileResource);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeIOException(e);
            }
        }
    });

    FileInputResource(File fileResource) {
        super(InputResource.Type.FILE);
        this.fileResource = fileResource;
    }

    @Override
    public File asFile() {
        return this.fileResource;
    }

    @Override
    public URL asUrl() {
        return null;
    }

    @Override
    public SeekableStream asUnbufferedSeekableStream() {
        return this.lazySeekableStream.get();
    }

    @Override
    public InputStream asUnbufferedInputStream() {
        return this.asUnbufferedSeekableStream();
    }
}

