/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.classifier.utils;

import edu.msu.cme.rdp.readseq.readers.Sequence;
import edu.msu.cme.rdp.readseq.utils.IUBUtilities;
import edu.msu.cme.rdp.readseq.utils.SeqUtils;
import edu.msu.cme.rdp.readseq.utils.orientation.GoodWordIterator;
import java.io.IOException;

public class ClassifierSequence
extends Sequence {
    private boolean reverse = false;
    private Integer goodWordCount = 0;
    private int[] wordIndexArr = null;

    public ClassifierSequence(Sequence seq) throws IOException {
        this(seq.getSeqName(), seq.getDesc(), seq.getSeqString());
    }

    public ClassifierSequence(String seqName, String desc, String seqString) throws IOException {
        super(seqName, desc, SeqUtils.getUnalignedSeqString((String)seqString));
        if (!this.getSeqString().isEmpty()) {
            GoodWordIterator iterator = new GoodWordIterator(this.getSeqString());
            try {
                this.wordIndexArr = iterator.getWordArr();
                this.goodWordCount = this.wordIndexArr.length;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    protected void setSeqString(String s) {
        this.seqString = s;
    }

    public int[] getWordIndexArr() {
        return this.wordIndexArr;
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public ClassifierSequence getReversedSeq() throws IOException {
        ClassifierSequence retval = new ClassifierSequence(this.seqName, this.desc, IUBUtilities.reverseComplement((String)this.seqString));
        retval.reverse = true;
        return retval;
    }

    public int getGoodWordCount() {
        return this.goodWordCount;
    }
}

