/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.readseq.utils;

import java.util.Arrays;

public class NuclBinMapping {
    public static final char[] intToChar = new char[]{'a', 'c', 'g', 't'};
    public static final byte[] validateLookup = new byte[127];
    public static final byte[] complementLookup = new byte[127];
    public static final int a = 0;
    public static final int c = 1;
    public static final int g = 2;
    public static final int t = 3;

    public static String fromByteArray(byte[] seq) {
        StringBuilder ret = new StringBuilder();
        for (byte b : seq) {
            if (b > intToChar.length) {
                throw new IllegalArgumentException("Bases are expected to be in the range [0-3]");
            }
            ret.append(intToChar[b]);
        }
        return ret.toString();
    }

    public static byte[] toBytes(String seq) {
        char[] bases = seq.toCharArray();
        byte[] ret = new byte[bases.length];
        for (int index = 0; index < bases.length; ++index) {
            byte b = validateLookup[bases[index]];
            if (b == -1) {
                throw new IllegalArgumentException("Unable to process base " + (index + 1) + " (" + bases[index] + ")");
            }
            ret[index] = b;
        }
        return ret;
    }

    static {
        Arrays.fill(validateLookup, (byte)-1);
        NuclBinMapping.validateLookup[65] = 0;
        NuclBinMapping.validateLookup[67] = 1;
        NuclBinMapping.validateLookup[71] = 2;
        NuclBinMapping.validateLookup[84] = 3;
        NuclBinMapping.validateLookup[97] = 0;
        NuclBinMapping.validateLookup[99] = 1;
        NuclBinMapping.validateLookup[103] = 2;
        NuclBinMapping.validateLookup[116] = 3;
        NuclBinMapping.validateLookup[85] = 3;
        NuclBinMapping.validateLookup[117] = 3;
        Arrays.fill(complementLookup, (byte)-1);
        NuclBinMapping.complementLookup[65] = 3;
        NuclBinMapping.complementLookup[84] = 0;
        NuclBinMapping.complementLookup[85] = 0;
        NuclBinMapping.complementLookup[71] = 1;
        NuclBinMapping.complementLookup[67] = 2;
        NuclBinMapping.complementLookup[97] = 3;
        NuclBinMapping.complementLookup[116] = 0;
        NuclBinMapping.complementLookup[117] = 0;
        NuclBinMapping.complementLookup[103] = 1;
        NuclBinMapping.complementLookup[99] = 2;
        NuclBinMapping.complementLookup[0] = 3;
        NuclBinMapping.complementLookup[3] = 0;
        NuclBinMapping.complementLookup[2] = 1;
        NuclBinMapping.complementLookup[1] = 2;
    }
}

