## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  comment = "##",
  message = FALSE
)

## ----install, eval=FALSE------------------------------------------------------
# if (!requireNamespace("BiocManager", quietly = TRUE))
#     install.packages("BiocManager")
# BiocManager::install("notameStats")

## ----message = FALSE----------------------------------------------------------
library(notame)
library(notameViz)
library(notameStats)

ppath <- tempdir()
init_log(log_file = file.path(ppath, "log.txt"))

data(hilic_neg_sample, package = "notame")
data(toy_notame_set, package = "notame")

## -----------------------------------------------------------------------------
toy_notame_set <- mark_nas(toy_notame_set, value = 0)

# Impute missing values, required especially for multivariate methods
toy_notame_set <- notame::impute_rf(toy_notame_set)

sum_stats <- summary_statistics(toy_notame_set, grouping_cols = "Group")
toy_notame_set <- notame::join_rowData(toy_notame_set, sum_stats)

d_results <- cohens_d(toy_notame_set, group = "Group")
toy_notame_set <- notame::join_rowData(toy_notame_set, d_results)

fc <- fold_change(toy_notame_set, group = "Group")
toy_notame_set <- notame::join_rowData(toy_notame_set, fc)

colnames(rowData(toy_notame_set))

## -----------------------------------------------------------------------------

toy_notame_set <- notame::flag_quality(toy_notame_set)
toy_notame_set <- notame::drop_qcs(toy_notame_set)

lm_results <- perform_lm(toy_notame_set, 
  formula_char = "Feature ~ Group + Time")


## -----------------------------------------------------------------------------
# nRep = 2 for quick example
pls_model <- muvr_analysis(toy_notame_set, 
  y = "Injection_order", nRep = 2, method = "PLS")
  
class(pls_model)


## -----------------------------------------------------------------------------
rf <- fit_rf(toy_notame_set, y = "Group")

class(rf)

head(importance_rf(rf))

## -----------------------------------------------------------------------------
pls_res <- mixomics_pls(toy_notame_set, y = "Injection_order", ncomp = 3)

class(pls_res)

## ----echo = FALSE, results = 'markup'-----------------------------------------
sessionInfo()

