## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
    collapse = TRUE,
    comment = "#>"
)

## ----eval = FALSE-------------------------------------------------------------
# if (!require("BiocManager", quietly = TRUE)) {
#     install.packages("BiocManager")
# }
# 
# BiocManager::install("MSstatsBioNet")

## -----------------------------------------------------------------------------
input = data.table::fread(system.file(
    "extdata/msstats.csv",
    package = "MSstatsBioNet"
))

## -----------------------------------------------------------------------------
library(MSstatsConvert)
msstats_imported = FragPipetoMSstatsFormat(input, use_log_file = FALSE)
head(msstats_imported)

## -----------------------------------------------------------------------------
library(MSstats)
QuantData <- dataProcess(msstats_imported, use_log_file = FALSE)
model <- groupComparison(
    contrast.matrix = "pairwise",
    data = QuantData,
    use_log_file = FALSE
)
head(model$ComparisonResult)

## -----------------------------------------------------------------------------
library(MSstatsBioNet)
annotated_df = annotateProteinInfoFromIndra(model$ComparisonResult, "Uniprot")
head(annotated_df)

## -----------------------------------------------------------------------------
subnetwork <- getSubnetworkFromIndra(
    annotated_df, 
    pvalueCutoff = 0.05, 
    statement_types = c("Complex", "IncreaseAmount", "DecreaseAmount", "Inhibition", "Activation", "Phosphorylation")
)
head(subnetwork$nodes)
head(subnetwork$edges)

## -----------------------------------------------------------------------------
previewNetworkInBrowser(subnetwork$nodes, subnetwork$edges, displayLabelType = "hgncName")

## -----------------------------------------------------------------------------
sessionInfo()

