/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyFactory;
import org.apache.derby.iapi.sql.LanguageFactory;
import org.apache.derby.iapi.sql.ParameterValueSet;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.conn.LanguageConnectionFactory;
import org.apache.derby.impl.sql.GenericParameterValueSet;
import org.apache.derby.impl.sql.GenericResultDescription;
import org.apache.derby.impl.sql.LanguageDbPropertySetter;
import org.apache.derby.shared.common.error.StandardException;

public class GenericLanguageFactory
implements LanguageFactory,
ModuleControl {
    private GenericParameterValueSet emptySet;

    @Override
    public void boot(boolean bl, Properties properties) throws StandardException {
        LanguageConnectionFactory languageConnectionFactory = (LanguageConnectionFactory)GenericLanguageFactory.findServiceModule(this, "org.apache.derby.iapi.sql.conn.LanguageConnectionFactory");
        PropertyFactory propertyFactory = languageConnectionFactory.getPropertyFactory();
        if (propertyFactory != null) {
            propertyFactory.addPropertySetNotification(new LanguageDbPropertySetter());
        }
        this.emptySet = new GenericParameterValueSet(null, 0, false);
    }

    @Override
    public void stop() {
    }

    @Override
    public ParameterValueSet newParameterValueSet(ClassInspector classInspector, int n, boolean bl) {
        if (n == 0) {
            return this.emptySet;
        }
        return new GenericParameterValueSet(classInspector, n, bl);
    }

    @Override
    public ResultDescription getResultDescription(ResultDescription resultDescription, int[] nArray) {
        return new GenericResultDescription(resultDescription, nArray);
    }

    @Override
    public ResultDescription getResultDescription(ResultColumnDescriptor[] resultColumnDescriptorArray, String string) {
        return new GenericResultDescription(resultColumnDescriptorArray, string);
    }

    private static Object findServiceModule(final Object object, final String string) throws StandardException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws StandardException {
                    return Monitor.findServiceModule(object, string);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw StandardException.plainWrapException((Throwable)privilegedActionException);
        }
    }
}

