% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sig_genes_extract.R
\name{sig_genes_extract}
\alias{sig_genes_extract}
\title{Extract significant genes}
\usage{
sig_genes_extract(
  n = 10,
  modeling_results = fetch_data(type = "modeling_results"),
  model_type = names(modeling_results)[1],
  reverse = FALSE,
  sce_layer = fetch_data(type = "sce_layer"),
  gene_name = "gene_name"
)
}
\arguments{
\item{n}{The number of the top ranked genes to extract.}

\item{modeling_results}{Defaults to the output of
\code{fetch_data(type = 'modeling_results')}. This is a list of tables with the
columns \verb{f_stat_*} or \verb{t_stat_*} as well as \verb{p_value_*} and \verb{fdr_*} plus
\code{ensembl}. The column name is used to extract the statistic results, the
p-values, and the FDR adjusted p-values. Then the \code{ensembl} column is used
for matching in some cases. See \code{\link[=fetch_data]{fetch_data()}} for more details. Typically
this is the set of reference statistics used in \code{layer_stat_cor()}.}

\item{model_type}{A named element of the \code{modeling_results} list. By default
that is either \code{enrichment} for the model that tests one human brain layer
against the rest (one group vs the rest), \code{pairwise} which compares two
layers (groups) denoted by \code{layerA-layerB} such that \code{layerA} is greater
than \code{layerB}, and \code{anova} which determines if any layer (group) is different
from the rest adjusting for the mean expression level. The statistics for
\code{enrichment} and \code{pairwise} are t-statistics while the \code{anova} model ones
are F-statistics.}

\item{reverse}{A \code{logical(1)} indicating whether to multiply by \code{-1} the
input statistics and reverse the \code{layerA-layerB} column names (using the \code{-})
into \code{layerB-layerA}.}

\item{sce_layer}{Defaults to the output of
\code{fetch_data(type = 'sce_layer')}. This is a
\linkS4class{SingleCellExperiment}
object with the spot-level Visium data compressed via pseudo-bulking to the
layer-level (group-level) resolution. See \code{\link[=fetch_data]{fetch_data()}} for more details.}

\item{gene_name}{A \code{character(1)} specifying the \code{rowData(sce_layer)}
column with the gene names that match the \code{rownames(modeling_results)}.
Defaults to \code{"gene_name"}.}
}
\value{
A \code{data.frame()} with the top \code{n} significant genes
(as ordered by their statistics in decreasing order) in long format. The
specific columns are described further in the vignette.
}
\description{
From the layer-level modeling results, this function extracts the top \code{n}
significant genes. This is the workhorse function used by
\code{\link[=sig_genes_extract_all]{sig_genes_extract_all()}} through which we obtain the information that can
then be used by functions such as \code{\link[=layer_boxplot]{layer_boxplot()}} for constructing
informative titles.
}
\examples{

## Obtain the necessary data
if (!exists("modeling_results")) {
    modeling_results <- fetch_data(type = "modeling_results")
}
if (!exists("sce_layer")) sce_layer <- fetch_data(type = "sce_layer")

## anova top 10 genes
sig_genes_extract(
    modeling_results = modeling_results,
    sce_layer = sce_layer
)

## Extract all genes
sig_genes_extract(
    modeling_results = modeling_results,
    sce_layer = sce_layer,
    n = nrow(sce_layer)
)
}
\references{
Adapted from
https://github.com/LieberInstitute/HumanPilot/blob/master/Analysis/Layer_Guesses/layer_specificity_functions.R
}
\seealso{
Other Layer modeling functions: 
\code{\link{layer_boxplot}()},
\code{\link{sig_genes_extract_all}()}
}
\concept{Layer modeling functions}
