% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locate_images.R
\name{locate_images}
\alias{locate_images}
\title{Locate image files}
\usage{
locate_images(spe, image_dir, image_pattern)
}
\arguments{
\item{spe}{A
\link[SpatialExperiment:SpatialExperiment]{SpatialExperiment-class}
object. See \code{\link[=fetch_data]{fetch_data()}} for how to download some example objects or
\code{\link[=read10xVisiumWrapper]{read10xVisiumWrapper()}} to read in \code{spaceranger --count} output files and
build your own \code{spe} object.}

\item{image_dir}{A \code{character(1)} specifying a path to a directory containing
image files with the pattern \code{sampleID_pattern.png}.}

\item{image_pattern}{A \code{character(1)} specifying the pattern for the image
files.}
}
\value{
A named \code{character()} vector with the path to images.
}
\description{
Creates a named \code{character()} vector that can be helpful for locating
image files and used with \code{add_images()}. This function is not necessary if
the image files don't use the \code{spe$sample_id}.
}
\examples{
\dontrun{
locate_images(spe, tempdir(), "testImage")
}
}
\seealso{
Other Functions for adding non-standard images: 
\code{\link{add_images}()}
}
\concept{Functions for adding non-standard images}
