% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_key.R
\name{add_key}
\alias{add_key}
\title{Create a unique spot identifier}
\usage{
add_key(spe, overwrite = TRUE)
}
\arguments{
\item{spe}{A
\link[SpatialExperiment:SpatialExperiment]{SpatialExperiment-class} object.}

\item{overwrite}{A \code{logical(1)} indicating whether to overwrite the \code{spe$key}.}
}
\value{
A
\link[SpatialExperiment:SpatialExperiment]{SpatialExperiment-class} object
with \code{key} added to the \code{colData(spe)} that is unique across all spots.
}
\description{
This function adds \code{spe$key} to a
\link[SpatialExperiment:SpatialExperiment]{SpatialExperiment-class} object
which is unique across all spots.
}
\examples{
if (enough_ram()) {
    ## Obtain the necessary data
    if (!exists("spe")) spe <- fetch_data("spe")

    ## This object already has a 'key'
    head(spe$key)

    ## We can clean it
    spe$key_original <- spe$key
    spe$key <- NULL

    ## and then add it back
    spe <- add_key(spe)
    head(spe$key)

    ## Note that the original 'key' order was 'sample_id'_'barcode' and we'
    ## have since changed it to 'barcode'_'sample_id'.

    ## Below we restore the original 'key'
    spe$key <- spe$key_original
    spe$key_original <- NULL
    head(spe$key)
}
}
