datacache <- new.env(hash=TRUE, parent=emptyenv())

reactome <- function() showQCData("reactome", datacache)
reactome_dbconn <- function() dbconn(datacache)
reactome_dbfile <- function() dbfile(datacache)
reactome_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
reactome_dbInfo <- function() dbInfo(datacache)

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "reactome.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the ReactomeDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ReactomeDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)

    ## Create the AnnObj instances
    ann_objs <- AnnotationDbi:::createAnnObjs.reactome("reactome", "reactome", dbconn, datacache)

    mergeToNamespaceAndExport(ann_objs, pkgname)
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(reactome_dbconn())
}

