datacache <- new.env(hash=TRUE, parent=emptyenv())

org.Rn.eg <- function() showQCData("org.Rn.eg", datacache)
org.Rn.eg_dbconn <- function() dbconn(datacache)
org.Rn.eg_dbfile <- function() dbfile(datacache)
org.Rn.eg_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
org.Rn.eg_dbInfo <- function() dbInfo(datacache)

org.Rn.egORGANISM <- "Rattus norvegicus"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "org.Rn.eg.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"OrgDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("RAT_DB", "org.Rn.eg", "Rat", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("org.Rn.eg"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(org.Rn.eg_dbconn())
}

