% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/array_coord_utils.R
\name{.fit_to_array}
\alias{.fit_to_array}
\title{Fit spots to a new Visium-like array: fast Euclidean approach}
\usage{
.fit_to_array(coords, inter_spot_dist_px)
}
\arguments{
\item{coords}{A \code{data.frame()} whose rows represent capture areas of the
same group, and containing columns 'array_row', 'array_col',
'pxl_row_in_fullres', and 'pxl_col_in_fullres'.}

\item{inter_spot_dist_px}{\code{numeric(1)} vector giving the pixel distance
between any 2 spots in the new coordinates.}
}
\value{
A \link[dplyr:reexports]{tibble} with modified \code{array_row} + \code{array_col}
columns, as well as new \code{pxl_row_in_fullres_rounded} and
\code{pxl_col_in_fullres_rounded} columns representing the pixel coordinates
rounded to the nearest exact array coordinates.
}
\description{
Given transformed pixel coordinates, modify the 'array_row' and
'array_col' columns to represent a larger Visium capture area containing
all capture areas in a common coordinate system. The number of
array rows/cols generally changes from the Visium standards of 78 and 128
(and even may change in ratio between num rows and num cols).
}
\details{
The mapping algorithm minimizes Euclidean distance of each source spot to
each target spot. Runtime is O(n) with the number of spots, making it
extremely fast. However, the Euclidean approach countintuitively may
result in duplicated mappings (one source to the same target) as well as
unexpected "holes" in the target array, which is often undesirable
downstream.
}
\author{
Nicholas J. Eagles
}
\keyword{internal}
