% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/universalmotif_df.R
\name{tidy-motifs}
\alias{tidy-motifs}
\alias{to_df}
\alias{update_motifs}
\alias{to_list}
\alias{requires_update}
\title{Tidy manipulation of motifs.}
\usage{
to_df(motifs, extrainfo = TRUE)

update_motifs(motif_df, extrainfo = TRUE, force = FALSE)

to_list(motif_df, extrainfo = TRUE, force = FALSE)

requires_update(motifs, extrainfo = TRUE)
}
\arguments{
\item{motifs}{List of motifs.}

\item{extrainfo}{Use the \code{extrainfo} slot in the tidy \code{data.frame}. The
column names will be taken from the character vectors themselves, and
unnamed elements will be assigned a unique name. To add elements to the
slot, simply create new columns in the \code{data.frame}. Note that these will
be coerced into characters. If \code{extrainfo} is not set to \code{TRUE} in
\code{to_df()}, then the contents of the slot will not be transferred to the
\code{data.frame}. If \code{extrainfo} is not set to \code{TRUE} in \code{update_motifs()}
or \code{to_list()}, then the extra columns will be discarded.}

\item{motif_df}{Motif \code{data.frame} generated by \code{\link[=to_df]{to_df()}}.}

\item{force}{Whether to coerce non-character data types into characters for
inclusion in \code{extrainfo}. If \code{force} is \code{FALSE} (the default), columns which
are not of type "character", "numeric", or "integer" (for example, list
columns, or logical values), will not be added to the motif \code{extrainfo}
slot, but will be passed onto the returned \code{universalmotif_df} unchanged.
Setting \code{force = TRUE} coerces these values into a character, adding them
to the \code{extrainfo} slot, and updating the \code{universalmotif_df} columns to
reflect this coercion. In other words, forcing inclusion of these data is
destructive and will change the column values. Use with caution.}
}
\value{
For \code{\link[=to_df]{to_df()}}: a \code{data.frame} with the exposed slots as columns.

For \code{\link[=update_motifs]{update_motifs()}}: the updated \code{data.frame}.

For \code{\link[=requires_update]{requires_update()}}: \code{TRUE} if the motifs are out of date,
\code{FALSE} if otherwise. Note that this function uses \code{identical()}
to check for this, which can be quite slow for large datasets. It
is usually just as fast to simply run \code{\link[=update_motifs]{update_motifs()}} in such
cases.

For \code{\link[=to_list]{to_list()}}: a list of motifs.
}
\description{
Tidy manipulation of motifs.
}
\details{
To turn off the informative messages/warnings when printing the object to
the console, set \code{options(universalmotif_df.warning=FALSE)}.
}
\examples{
\dontrun{
library(universalmotif)
library(dplyr)

m <- c(create_motif(name = "motif A"), create_motif(name = "motif B"))

# Change the names of the motifs using the tidy way:
m <- m \%>\%
   to_df() \%>\%
   mutate(name = paste0(name, "-2")) \%>\%
   to_list()

# Add your own metadata to be stored in the extrainfo slot:
m_df <- to_df(m)
m_df$MyMetadata <- c("Info_1", "Info_2")
m <- to_list(m_df, extrainfo = TRUE)
}

}
\author{
Benjamin Jean-Marie Tremblay, \email{benjamin.tremblay@uwaterloo.ca}
}
