% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_uniprobe.R
\name{read_uniprobe}
\alias{read_uniprobe}
\title{Import UNIPROBE motifs.}
\usage{
read_uniprobe(file, skip = 0)
}
\arguments{
\item{file}{\code{character(1)} File name.}

\item{skip}{\code{numeric(1)} If not zero, will skip however many desired lines in the
file before starting to read.}
}
\value{
\code{list} \linkS4class{universalmotif} objects.
}
\description{
Import UNIPROBE formatted motifs. Assumed DNA.
}
\examples{
uniprobe.minimal <- read_uniprobe(system.file("extdata", "uniprobe_minimal.txt",
                                              package = "universalmotif"))
uniprobe.full <- read_uniprobe(system.file("extdata", "uniprobe_full.txt",
                                           package = "universalmotif"))

}
\references{
Hume MA, Barrera LA, Gisselbrecht SS, Bulyk ML (2015). “UniPROBE,
update 2015: new tools and content for the online database of
protein-binding microarray data on protein-DNA interactions.”
\emph{Nucleic Acids Research}, \strong{43}, D117-D122.
}
\seealso{
Other read_motifs: 
\code{\link{read_cisbp}()},
\code{\link{read_homer}()},
\code{\link{read_jaspar}()},
\code{\link{read_matrix}()},
\code{\link{read_meme}()},
\code{\link{read_motifs}()},
\code{\link{read_transfac}()}
}
\author{
Benjamin Jean-Marie Tremblay, \email{benjamin.tremblay@uwaterloo.ca}
}
\concept{read_motifs}
