% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyr_methods.R
\name{separate}
\alias{separate}
\alias{separate.SingleCellExperiment}
\title{Separate a character column into multiple columns with a regular
expression or numeric locations}
\usage{
\method{separate}{SingleCellExperiment}(
  data,
  col,
  into,
  sep = "[^[:alnum:]]+",
  remove = TRUE,
  convert = FALSE,
  extra = "warn",
  fill = "warn",
  ...
)
}
\arguments{
\item{data}{A data frame.}

\item{col}{<\code{\link[tidyr:tidyr_tidy_select]{tidy-select}}> Column to expand.}

\item{into}{Names of new variables to create as character vector.
Use \code{NA} to omit the variable in the output.}

\item{sep}{Separator between columns.

If character, \code{sep} is interpreted as a regular expression. The default
value is a regular expression that matches any sequence of
non-alphanumeric values.

If numeric, \code{sep} is interpreted as character positions to split at. Positive
values start at 1 at the far-left of the string; negative value start at -1 at
the far-right of the string. The length of \code{sep} should be one less than
\code{into}.}

\item{remove}{If \code{TRUE}, remove input column from output data frame.}

\item{convert}{If \code{TRUE}, will run \code{\link[=type.convert]{type.convert()}} with
\code{as.is = TRUE} on new columns. This is useful if the component
columns are integer, numeric or logical.

NB: this will cause string \code{"NA"}s to be converted to \code{NA}s.}

\item{extra}{If \code{sep} is a character vector, this controls what
happens when there are too many pieces. There are three valid options:
\itemize{
\item \code{"warn"} (the default): emit a warning and drop extra values.
\item \code{"drop"}: drop any extra values without a warning.
\item \code{"merge"}: only splits at most \code{length(into)} times
}}

\item{fill}{If \code{sep} is a character vector, this controls what
happens when there are not enough pieces. There are three valid options:
\itemize{
\item \code{"warn"} (the default): emit a warning and fill from the right
\item \code{"right"}: fill with missing values on the right
\item \code{"left"}: fill with missing values on the left
}}

\item{...}{Additional arguments passed on to methods.}
}
\value{
`tidySingleCellExperiment`
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}

\code{separate()} has been superseded in favour of \code{\link[tidyr:separate_wider_position]{separate_wider_position()}}
and \code{\link[tidyr:separate_wider_delim]{separate_wider_delim()}} because the two functions make the two uses
more obvious, the API is more polished, and the handling of problems is
better. Superseded functions will not go away, but will only receive
critical bug fixes.

Given either a regular expression or a vector of character positions,
\code{separate()} turns a single character column into multiple columns.
}
\examples{
data(pbmc_small)
un <- pbmc_small |> unite("new_col", c(orig.ident, groups))
un |> separate(new_col, c("orig.ident", "groups"))

}
\seealso{
\code{\link[tidyr:unite]{unite()}}, the complement, \code{\link[tidyr:extract]{extract()}} which uses regular
expression capturing groups.
}
