% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr_methods.R
\name{rowwise}
\alias{rowwise}
\alias{rowwise.SingleCellExperiment}
\title{Group input by rows}
\usage{
\method{rowwise}{SingleCellExperiment}(data, ...)
}
\arguments{
\item{data}{Input data frame.}

\item{...}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> Variables to be preserved
when calling \code{\link[dplyr:summarise]{summarise()}}. This is typically a set of variables whose
combination uniquely identify each row.

\strong{NB}: unlike \code{group_by()} you can not create new variables here but
instead you can select multiple variables with (e.g.) \code{everything()}.}
}
\value{
A row-wise data frame with class \code{rowwise_df}. Note that a
\code{rowwise_df} is implicitly grouped by row, but is not a \code{grouped_df}.
}
\description{
\code{rowwise()} allows you to compute on a data frame a row-at-a-time.
This is most useful when a vectorised function doesn't exist.

Most dplyr verbs preserve row-wise grouping. The exception is \code{\link[dplyr:summarise]{summarise()}},
which return a \link[dplyr]{grouped_df}. You can explicitly ungroup with \code{\link[dplyr:ungroup]{ungroup()}}
or \code{\link[dplyr:as_tibble]{as_tibble()}}, or convert to a \link[dplyr]{grouped_df} with \code{\link[dplyr:group_by]{group_by()}}.
}
\section{List-columns}{


Because a rowwise has exactly one row per group it offers a small
convenience for working with list-columns. Normally, \code{summarise()} and
\code{mutate()} extract a groups worth of data with \code{[}. But when you index
a list in this way, you get back another list. When you're working with
a \code{rowwise} tibble, then dplyr will use \code{[[} instead of \code{[} to make your
life a little easier.

}

\examples{
# TODO

}
\seealso{
\code{\link[dplyr:nest_by]{nest_by()}} for a convenient way of creating rowwise data frames
with nested data.
}
