% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perm_test.R
\name{perm_test}
\alias{perm_test}
\title{The function perm_test is the main function to carry out the hypothesis test procedure
    proposed in the paper.}
\usage{
perm_test(
  r_labels,
  c_labels,
  coords = NULL,
  dist_mat = NULL,
  f_func_input = NULL,
  h_func_input = NULL,
  alpha_val = 0.8,
  use_parallel = TRUE,
  replicate_times = 100,
  random_seed = 42,
  spe = NULL
)
}
\arguments{
\item{r_labels}{Annotated labels of all spots/cells. Can be numeric vector or character vector.}

\item{c_labels}{Estimated labels obtained by a certain spatial clustering method.}

\item{coords}{Spatial coordinates (2 columns). 1st column: first dimension coordinate.
2nd column: second dimension coordinate. Default is NULL.}

\item{dist_mat}{Distance matrix provided by users. If both coords and dist_mat
are provided, we will directly use the distance matrix. Default is NULL.
Please notice that if dist_mat is sparse, the weight function for object pairs without recorded distances
degenerates to the setting used in the classical Rand index.}

\item{f_func_input}{R function; function f provided by users.}

\item{h_func_input}{R function; function h provided by users.}

\item{alpha_val}{Parameter in the default functions f and h, which belongs to the open interval (0, 1)
to keep a positive gap between the maximal weight of the disagreement pair and the weight one of the agreement pair.
Default is 0.8.}

\item{use_parallel}{Logical; if TRUE, use parallel code to permute the two partitions. Default is TRUE.}

\item{replicate_times}{Number of permutations for both the reference and clustering partitions. Default is 100.}

\item{random_seed}{Random seed for reproducibility. Default is 42.}

\item{spe}{SpatialExperiment object; stores various components of spatial transcriptomics data, including
spatialCoords: A matrix containing the spatial coordinates;
colData$cell_type: Annotated cell type labels for each spot or cell;
colData$cluster: Clustering labels for each spot or cell.
Default is NULL.}
}
\value{
spARI returns an R numeric including the following information.
\item{spARI_obs}{numeric, the observed spARI value calculated by r_labels and c_labels}
\item{p_value}{numeric, the p-value of the hypothesis testing}
}
\description{
The function perm_test is the main function to carry out the hypothesis test procedure
    proposed in the paper.
}
\examples{
library(spARI)
data(spARI_example_data)
true_labels = spARI_example_data$true_labels
c1_labels = spARI_example_data$c1_labels
c2_labels = spARI_example_data$c2_labels
coords = spARI_example_data$coords
test_res1 = perm_test(r_labels=true_labels, c_labels=c1_labels, coords=coords,
                      use_parallel=FALSE)
test_res2 = perm_test(r_labels=true_labels, c_labels=c2_labels, coords=coords,
                      use_parallel=FALSE)

}
