% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shapeMetricsFromSF.R
\name{stFeatureAxes}
\alias{stFeatureAxes}
\title{Calculate the length of feature axes of an sf polygon}
\usage{
stFeatureAxes(sfPoly)
}
\arguments{
\item{sfPoly}{\code{POLYGON } of class \code{sf}}
}
\value{
list; list containing the major and minor axis lengths
}
\description{
Calculate the length of feature axes of an sf polygon
}
\examples{
matrixR <- matrix(c(
    0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 1, 1, 1, 1, 1, 0, 0, 0,
    0, 1, 1, 0, 0, 1, 1, 0, 0,
    0, 1, 1, 0, 0, 1, 1, 0, 0,
    0, 1, 1, 1, 1, 1, 0, 0, 0,
    0, 1, 1, 0, 1, 1, 0, 0, 0,
    0, 1, 1, 0, 0, 1, 1, 0, 0,
    0, 1, 1, 0, 0, 1, 1, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0
), nrow = 9, byrow = TRUE)
polyR <- binaryImageToSF(matrixR, xmin = 0, xmax = 1, ymin = 0, ymax = 1)
stFeatureAxes(polyR)
}
