% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{binaryImageToSF}
\alias{binaryImageToSF}
\title{Converts a binary matrix to an sf polygon}
\usage{
binaryImageToSF(binaryMatrix, xmin, xmax, ymin, ymax)
}
\arguments{
\item{binaryMatrix}{matrix; binary matrix}

\item{xmin}{integer; minimum x coordinate of the coordinate system}

\item{xmax}{integer; maximum x coordinate of the coordinate system}

\item{ymin}{integer; minimum y coordinate of the coordinate system}

\item{ymax}{integer; maximum y coordinate of the coordinate system}
}
\value{
sf object
}
\description{
Converts a binary matrix to an sf polygon
}
\examples{
matrixR <- matrix(c(
    0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 1, 1, 1, 1, 1, 0, 0, 0,
    0, 1, 1, 0, 0, 1, 1, 0, 0,
    0, 1, 1, 0, 0, 1, 1, 0, 0,
    0, 1, 1, 1, 1, 1, 0, 0, 0,
    0, 1, 1, 0, 1, 1, 0, 0, 0,
    0, 1, 1, 0, 0, 1, 1, 0, 0,
    0, 1, 1, 0, 0, 1, 1, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0
), nrow = 9, byrow = TRUE)
polyR <- binaryImageToSF(matrixR, xmin = 0, xmax = 1, ymin = 0, ymax = 1)
plot(polyR)
}
