% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothclust.R
\name{smoothclust}
\alias{smoothclust}
\title{smoothclust}
\usage{
smoothclust(
  input,
  assay_name = "counts",
  spatial_coords = NULL,
  method = c("uniform", "kernel", "knn"),
  bandwidth = 0.05,
  k = 18,
  truncate = 0.05
)
}
\arguments{
\item{input}{Input data, which can be provided as either a
\code{SpatialExperiment} object or a numeric matrix. If this is a
\code{SpatialExperiment} object, it is assumed to contain either raw
expression counts or logcounts in the \code{assay} slots and spatial
coordinates in the \code{spatialCoords} slot. If this is a numeric matrix,
it is assumed to contain either raw expression counts or logcounts, and
spatial coordinates need to be provided separately with the
\code{spatial_coords} argument.}

\item{assay_name}{For a \code{SpatialExperiment} input object, this argument
specifies the name of the \code{assay} containing the expression values to
be smoothed. In most cases, this will be \code{counts}, which contains raw
expression counts. Alternatively, \code{logcounts} may also be used. Note
that if \code{logcounts} are used, the smoothed values represent geometric
averages. This argument is only used if the input is a
\code{SpatialExperiment} object. Default = \code{counts}.}

\item{spatial_coords}{Numeric matrix of spatial coordinates, assumed to
contain x coordinates in first column and y coordinates in second column.
This argument is only used if the input is a numeric matrix.}

\item{method}{Method used for smoothing. Options are \code{uniform},
\code{kernel}, and \code{knn}. The \code{uniform} method calculates
unweighted averages across spatial locations within a circular window with
radius \code{bandwidth} at each spatial location, which smooths out spatial
variability as well as sparsity due to sampling variability. The
\code{kernel} method calculates a weighted average using a truncated
exponential kernel applied to Euclidean distances with a length scale
parameter equal to \code{bandwidth}, which provides a more sophisticated
approach to smoothing out spatial variability but may be affected by
sparsity due to sampling variability (especially sparsity at the index
point), and is computationally slower. The \code{knn} method calculates an
unweighted average across the index point and its k nearest neighbors, and
is the fastest method. Default = \code{uniform}.}

\item{bandwidth}{Bandwidth parameter for smoothing, expressed as proportion
of width or height (whichever is greater) of tissue area. Only used for
\code{method = "uniform"} or \code{method = "kernel"}. For \code{method =
"uniform"}, the bandwidth represents the radius of a circle, and unweighted
averages are calculated across neighboring points within this circle. For
\code{method = "kernel"}, the averaging is weighted by distances scaled
using a truncated exponential kernel applied to Euclidean distances. For
example, a bandwidth of 0.05 will smooth values across neighbors weighted
by distances scaled using a truncated exponential kernel with length scale
equal to 5% of the width or height (whichever is greater) of the tissue
area. Weights for \code{method = "kernel"} are truncated at small values
for computational efficiency. Default = 0.05.}

\item{k}{Number of nearest neighbors parameter for \code{method = "knn"}.
Only used for \code{method == "knn"}. Unweighted averages are calculated
across the index point and its k nearest neighbors. Default = 18 (based on
two layers in honeycomb pattern for 10x Genomics Visium platform).}

\item{truncate}{Truncation threshold parameter if \code{method = "kernel"}.
Kernel weights below this value are set to zero for computational
efficiency. Only used for \code{method = "kernel"}. Default = 0.05.}
}
\value{
Returns spatially smoothed expression values, which can then be used
  as the input for further downstream analyses. Results are returned either
  as a \code{SpatialExperiment} object containing a new \code{assay} named
  \code{<assay_name>_smooth} (e.g. \code{counts_smooth} or
  \code{logcounts_smooth}), or as a numeric matrix, depending on the input
  type.
}
\description{
Method for identification of spatial domains and spatially-aware clustering.
}
\details{
Method for identification of spatial domains and spatially-aware clustering
in spatial transcriptomics data.

Method for identification of spatial domains and spatially-aware clustering
in spatial transcriptomics data. The method generates spatial domains with
smooth boundaries by smoothing gene expression profiles across neighboring
spatial locations, followed by unsupervised clustering. Spatial domains
consisting of consistent mixtures of cell types may then be further
investigated by applying cell type compositional analyses or differential
analyses.
}
\examples{
library(STexampleData)

# load data
spe <- Visium_humanDLPFC()
# keep spots over tissue
spe <- spe[, colData(spe)$in_tissue == 1]

# run smoothclust using default parameters
spe <- smoothclust(spe)

# see vignette for extended example

}
