% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SlalomModel-methods.R
\name{initSlalom}
\alias{initSlalom}
\title{Initialize a SlalomModel object}
\usage{
initSlalom(object, alpha_priors = NULL, epsilon_priors = NULL,
  noise_model = "gauss", seed = NULL, pi_prior = NULL, n_hidden = NULL,
  design = NULL, verbose = FALSE, save_init = FALSE)
}
\arguments{
\item{object}{a \code{Rcpp_SlalomModel} object}

\item{alpha_priors}{numeric(2) giving alpha and beta hyperparameters for a
gamma prior distribution for alpha parameters (precision of factor weights)}

\item{epsilon_priors}{numeric(2) giving alpha and beta hyperparameters for a
gamma prior distribution for noise precision parameters}

\item{noise_model}{character(1) defining noise model, defaults to "gauss" for
Gaussian noise model}

\item{seed}{integer(1) value supplying a random seed to make results
reproducible (default is \code{NULL})}

\item{pi_prior}{numeric matrix (genes x factors) giving prior probability of
a gene being active for a factor}

\item{n_hidden}{integer(1), number of hidden factors in model. Required if
\code{pi_prior} is not \code{NULL}, ignored otherwise.}

\item{design}{matrix of known factors (covariates) to fit in the
model. Optional if \code{pi_prior} is not \code{NULL}, ignored otherwise.}

\item{verbose}{logical(1), should messages be printed about what the function
is doing? Default is \code{TRUE}.}

\item{save_init}{logical(1), save the initial X values (factor states for
each cell) in the object? Default is \code{FALSE} as this is potentially a
large N (number of cell) by K (number of factors) matrix.}
}
\value{
an `Rcpp_SlalomModel` object
}
\description{
Initialize a SlalomModel with sensible starting values for parameters before
training the model.
}
\details{
It is strongly recommended to use \code{\link{newSlalomModel}} to
create the \code{\link{SlalomModel}} object prior to applying
\code{initSlalom}.
}
\examples{
gmtfile <- system.file("extdata", "reactome_subset.gmt", package = "slalom")
genesets <- GSEABase::getGmt(gmtfile)
data("mesc")
model <- newSlalomModel(mesc, genesets, n_hidden = 5, min_genes = 10)
model <- initSlalom(model)
}
\author{
Davis McCarthy
}
