% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggPerQCWrapper.R
\name{plotScdsHybridResults}
\alias{plotScdsHybridResults}
\title{Plots for runCxdsBcdsHybrid outputs.}
\usage{
plotScdsHybridResults(
  inSCE,
  sample = NULL,
  shape = NULL,
  groupBy = NULL,
  combinePlot = "all",
  violin = TRUE,
  boxplot = FALSE,
  dots = TRUE,
  reducedDimName = "UMAP",
  xlab = NULL,
  ylab = NULL,
  dim1 = NULL,
  dim2 = NULL,
  bin = NULL,
  binLabel = NULL,
  defaultTheme = TRUE,
  dotSize = 0.5,
  summary = "median",
  summaryTextSize = 3,
  transparency = 1,
  baseSize = 15,
  titleSize = NULL,
  axisLabelSize = NULL,
  axisSize = NULL,
  legendSize = NULL,
  legendTitleSize = NULL,
  relHeights = 1,
  relWidths = c(1, 1, 1),
  plotNCols = NULL,
  plotNRows = NULL,
  labelSamples = TRUE,
  samplePerColumn = TRUE,
  sampleRelHeights = 1,
  sampleRelWidths = 1
)
}
\arguments{
\item{inSCE}{Input \linkS4class{SingleCellExperiment} object with saved
dimension reduction components or a variable with saved results from
\link{runCxdsBcdsHybrid}. Required.}

\item{sample}{Character vector. Indicates which sample each cell belongs to.
Default NULL.}

\item{shape}{If provided, add shapes based on the value.}

\item{groupBy}{Groupings for each numeric value. A user may input a vector
equal length to the number of the samples in the SingleCellExperiment
object, or can be retrieved from the colData slot. Default NULL.}

\item{combinePlot}{Must be either "all", "sample", or "none". "all" will combine all plots into a single .ggplot object,
while "sample" will output a list of plots separated by sample. Default "all".}

\item{violin}{Boolean. If TRUE, will plot the violin plot. Default TRUE.}

\item{boxplot}{Boolean. If TRUE, will plot boxplots for each violin plot.
Default TRUE.}

\item{dots}{Boolean. If TRUE, will plot dots for each violin plot.
Default TRUE.}

\item{reducedDimName}{Saved dimension reduction name in the
\linkS4class{SingleCellExperiment} object. Required.}

\item{xlab}{Character vector. Label for x-axis. Default NULL.}

\item{ylab}{Character vector. Label for y-axis. Default NULL.}

\item{dim1}{1st dimension to be used for plotting. Can either be a string which specifies
the name of the dimension to be plotted from reducedDims, or a numeric value which specifies
the index of the dimension to be plotted. Default is NULL.}

\item{dim2}{2nd dimension to be used for plotting. Can either be a string which specifies
the name of the dimension to be plotted from reducedDims, or a numeric value which specifies
the index of the dimension to be plotted. Default is NULL.}

\item{bin}{Numeric vector. If single value, will divide the numeric values into the `bin` groups.
If more than one value, will bin numeric values using values as a cut point.}

\item{binLabel}{Character vector. Labels for the bins created by the `bin` parameter.
Default NULL.}

\item{defaultTheme}{Removes grid in plot and sets axis title size to 10
when TRUE. Default TRUE.}

\item{dotSize}{Size of dots. Default 0.5.}

\item{summary}{Adds a summary statistic, as well as a crossbar to the
violin plot. Options are "mean" or "median". Default NULL.}

\item{summaryTextSize}{The text size of the summary statistic displayed
above the violin plot. Default 3.}

\item{transparency}{Transparency of the dots, values will be 0-1. Default 1.}

\item{baseSize}{The base font size for all text. Default 12.
Can be overwritten by titleSize, axisSize, and axisLabelSize,
legendSize, legendTitleSize.}

\item{titleSize}{Size of title of plot. Default NULL.}

\item{axisLabelSize}{Size of x/y-axis labels. Default NULL.}

\item{axisSize}{Size of x/y-axis ticks. Default NULL.}

\item{legendSize}{size of legend. Default NULL.}

\item{legendTitleSize}{size of legend title. Default NULL.}

\item{relHeights}{Relative heights of plots when combine is set.}

\item{relWidths}{Relative widths of plots when combine is set.}

\item{plotNCols}{Number of columns when plots are combined in a grid.}

\item{plotNRows}{Number of rows when plots are combined in a grid.}

\item{labelSamples}{Will label sample name in title of plot if TRUE. Default TRUE.}

\item{samplePerColumn}{If TRUE, when there are multiple samples and combining by "all",
the output .ggplot will have plots from each sample on a single column. Default TRUE.}

\item{sampleRelHeights}{If there are multiple samples and combining by "all",
the relative heights for each plot.}

\item{sampleRelWidths}{If there are multiple samples and combining by "all",
the relative widths for each plot.}
}
\value{
list of .ggplot objects
}
\description{
A wrapper function which visualizes outputs from the
 runCxdsBcdsHybrid function stored in the colData slot of the
 SingleCellExperiment object via various plots.
}
\examples{
data(scExample, package="singleCellTK")
sce <- subsetSCECols(sce, colData = "type != 'EmptyDroplet'")
sce <- runQuickUMAP(sce)
sce <- runCxdsBcdsHybrid(sce)
plotScdsHybridResults(inSCE=sce, reducedDimName="UMAP")
}
