% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interaction.R
\name{addStrandCombination}
\alias{addStrandCombination}
\title{Add combination of anchor strand orientation.}
\usage{
addStrandCombination(gi, colname = "strandOrientation")
}
\arguments{
\item{gi}{\code{\link{GInteractions}}}

\item{colname}{name of the new column that is created in \code{gi}.}
}
\value{
The same \code{\link{GInteractions}} as \code{gi} but with an
  additional column indicating the four possible combinations of strands
  "forward", "reverse", "convergent", or "divergent".
}
\description{
Each anchor region has a strand that is \code{'+'} or \code{'-'}. Therefore,
the each interaction between two regions has one of the following strand
combinations: "forward", "reverse", "convergent", or "divergent". Unstranded
ranges, indicated by \code{*}, are treated as positive strand.
}
\examples{

# build example GRanges as anchors
anchorGR <- GRanges(
 rep("chr1", 4),
 IRanges(
   c(1, 5, 20, 14),
   c(4, 8, 23, 17)
 ),
 strand = c("+", "+", "+", "-"),
 score = c(5, 4, 6, 7)
)


# build example GIntreaction object
gi <- GInteractions(
 c(1, 2, 2),
 c(4, 3, 4),
 anchorGR,
 mode = "strict"
)

# add combination of anchor strands as new metadata column
gi <- addStrandCombination(gi)

# build small matrix to check strand combination
cbind(
as.character(strand(anchors(gi, "first"))),
as.character(strand(anchors(gi, "second"))),
mcols(gi)[, "strandOrientation"]
)

}
