% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project_homes.R
\name{project_homes}
\alias{project_homes}
\title{Find available project home options}
\usage{
project_homes(
  organism = c("human", "mouse"),
  recount3_url = getOption("recount3_url", "http://duffel.rail.bio/recount3")
)
}
\arguments{
\item{organism}{A \code{character(1)} specifying which organism you want to
download data from. Supported options are \code{"human"} or \code{"mouse"}.}

\item{recount3_url}{A \code{character(1)} specifying the home URL for \code{recount3}
or a local directory where you have mirrored \code{recount3}. Defaults to the
load balancer \url{http://duffel.rail.bio/recount3}, but can also be
\url{https://recount-opendata.s3.amazonaws.com/recount3/release} from
\url{https://registry.opendata.aws/recount/} or from
IDIES at JHU \url{https://idies.jhu.edu/recount3/data} (which redirects to
\url{https://data.idies.jhu.edu/recount3/data/}). You can
set the R option \code{recount3_url} (for example in your \code{.Rprofile}) if
you have a favorite mirror.}
}
\value{
A \code{character()} vector with the available \code{project_home} options.
}
\description{
This function finds the home for a given project (study) of interest based
on the \code{organism} and the \code{home_type}.
}
\details{
By default it reads a small text file from
\code{recount3_url}/\code{organism}/homes_index using \code{readLines()}. This text file
should contain each possible project home per line. See
\url{http://duffel.rail.bio/recount3/human/homes_index} for an example.
}
\examples{

## List the different available `project_home` options for the default
## arguments
project_homes("human")
project_homes("mouse")

## Test files
project_homes("human",
    recount3_url = "http://snaptron.cs.jhu.edu/data/temp/recount3"
)
}
\seealso{
Other internal functions for accessing the recount3 data: 
\code{\link{annotation_ext}()},
\code{\link{create_rse_manual}()},
\code{\link{file_retrieve}()},
\code{\link{locate_url}()},
\code{\link{locate_url_ann}()},
\code{\link{read_counts}()},
\code{\link{read_metadata}()}
}
\concept{internal functions for accessing the recount3 data}
