% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pengls.R
\name{pengls}
\alias{pengls}
\title{Iterative estimation of penalised generalised least squares}
\usage{
pengls(
  data,
  glsSt,
  xNames,
  outVar,
  corMat,
  lambda,
  foldid,
  exclude = NULL,
  maxIter = 30,
  tol = 0.05,
  verbose = FALSE,
  scale = FALSE,
  center = FALSE,
  optControl = lmeControl(opt = "optim", maxIter = 500, msVerbose = verbose, msMaxIter =
    500, niterEM = 1000, msMaxEval = 1000),
  nfolds = 10,
  penalty.factor = c(0, rep(1, length(xNames))),
  ...
)
}
\arguments{
\item{data}{A data matrix or data frame}

\item{glsSt}{a covariance structure, as supplied to nlme::gls as "correlation"}

\item{xNames}{names of the regressors in data}

\item{outVar}{name of the outcome variable in data}

\item{corMat}{a starting value for the correlation matrix. Taken to be a diagonal matrix if missing}

\item{lambda}{The penalty value for glmnet. If missing, the optimal value of vanilla glmnet without autocorrelation component is used}

\item{foldid}{An optional vector defining the fold}

\item{exclude}{indices of predictors to be excluded from intercept + xNames}

\item{maxIter}{maximum number of iterations between glmnet and gls}

\item{tol}{A convergence tolerance}

\item{verbose}{a boolean, should output be printed?}

\item{scale, center}{booleans, should regressors be scaled to zero mean and variance 1? Defaults to TRUE}

\item{optControl}{control arguments, passed onto nlme::gls' control argument}

\item{nfolds}{an integer, the number of folds used in cv.glmnet to find lambda}

\item{penalty.factor}{passed onto glmnet:glmnet. The first entry is zero by default for the intercept, which is not shrunk}

\item{...}{passed onto glmnet::glmnet}
}
\value{
A list with components
\item{glmnet}{The glmnet fit, which can be manipulated as such}
\item{gls}{A list with info on the estimated correlation matrix}
\item{iter}{The iterations needed}
\item{conv}{A boolean, indicating whether the iteration between mean model and covariance estimation converged}
\item{xNames,data,glsSt,outVar}{As provided}
\item{lambda}{The lambda penalty paraneter used}
}
\description{
Iterative estimation of penalised generalised least squares
}
\examples{
### Example 1: spatial data
# Define the dimensions of the data
library(nlme)
n <- 50 #Sample size
p <- 100 #Number of features
g <- 10 #Size of the grid
#Generate grid
Grid <- expand.grid("x" = seq_len(g), "y" = seq_len(g))
# Sample points from grid without replacement
GridSample <- Grid[sample(nrow(Grid), n, replace = FALSE),]
#Generate outcome and regressors
b <- matrix(rnorm(p*n), n , p)
a <- rnorm(n, mean = b \%*\% rbinom(p, size = 1, p = 0.2)) #20\% signal
#Compile to a matrix
df <- data.frame("a" = a, "b" = b, GridSample)
# Define the correlation structure (see ?nlme::gls), with initial nugget 0.5 and range 5
corStruct <- corGaus(form = ~ x + y, nugget = TRUE, value = c("range" = 5, "nugget" = 0.5))
#Fit the pengls model, for simplicity for a simple lambda
penglsFit <- pengls(data = df, outVar = "a", xNames = grep(names(df), pattern = "b", value =TRUE),
glsSt = corStruct, nfolds = 5)

### Example 2: timecourse data
dfTime <- data.frame("a" = a, "b" = b, "t" = seq_len(n))
dfTime$a[-1] = dfTime$a[-n]*0.25 #Some temporal signal
corStructTime <- corAR1(form = ~ t, value = 0.5)
penglsFitTime <- pengls(data = dfTime, outVar = "a",
xNames = grep(names(dfTime), pattern = "b", value =TRUE),
glsSt = corStructTime, nfolds = 5)
}
\seealso{
cv.pengls
}
