% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.pengls.R
\name{cv.pengls}
\alias{cv.pengls}
\title{Peform cross-validation pengls}
\usage{
cv.pengls(
  data,
  glsSt,
  xNames,
  outVar,
  corMat,
  nfolds,
  foldid,
  scale = FALSE,
  center = FALSE,
  cvType = "blocked",
  lambdas,
  transFun = "identity",
  exclude = NULL,
  transFunArgs = list(),
  loss = c("R2", "MSE"),
  verbose = FALSE,
  ...
)
}
\arguments{
\item{data}{A data matrix or data frame}

\item{glsSt}{a covariance structure, as supplied to nlme::gls as "correlation"}

\item{xNames}{names of the regressors in data}

\item{outVar}{name of the outcome variable in data}

\item{corMat}{a starting value for the correlation matrix. Taken to be a diagonal matrix if missing}

\item{nfolds}{an integer, the number of folds used in cv.glmnet to find lambda}

\item{foldid}{An optional vector defining the fold}

\item{scale, center}{booleans, should regressors be scaled to zero mean and variance 1? Defaults to TRUE}

\item{cvType}{A character vector defining the type of cross-validation.
Either "random" or "blocked", ignored if foldid is provided}

\item{lambdas}{an optional lambda sequence}

\item{transFun}{a transformation function to apply to predictions and outcome in the cross-validation}

\item{exclude}{indices of predictors to be excluded from intercept + xNames}

\item{transFunArgs}{Additional arguments passed onto transFun}

\item{loss}{a character vector, currently either 'R2' or 'MSE' indicating the
loss function (although R2 is not a proper loss...)}

\item{verbose}{a boolean, should output be printed?}

\item{...}{passed onto glmnet::glmnet}
}
\value{
A list with components
\item{lambda}{The series of lambdas}
\item{cvm}{The vector of mean R2's}
\item{cvsd}{The standard error of R2 at the maximum}
\item{cvOpt}{The R2 according to the 1 standard error rule}
\item{coefs}{The matrix of coefficients for every lambda value}
\item{bestFit}{The best fitting pengls model according to the 1 standard error rule}
\item{lambda.min}{Lambda value with maximal R2}
\item{lambda.1se}{Smallest lambda value within 1 standard error from the maximum}
\item{foldid}{The folds}
\item{glsSt}{The nlme correlation object}
\item{loss}{The loss function used}
}
\description{
Peform cross-validation pengls
}
\examples{
library(nlme)
library(BiocParallel)
n <- 20 #Sample size
p <- 50 #Number of features
g <- 10 #Size of the grid
#Generate grid
Grid <- expand.grid("x" = seq_len(g), "y" = seq_len(g))
# Sample points from grid without replacement
GridSample <- Grid[sample(nrow(Grid), n, replace = FALSE),]
#Generate outcome and regressors
b <- matrix(rnorm(p*n), n , p)
a <- rnorm(n, mean = b \%*\% rbinom(p, size = 1, p = 0.2)) #20\% signal
#Compile to a matrix
df <- data.frame("a" = a, "b" = b, GridSample)
# Define the correlation structure (see ?nlme::gls), with initial nugget 0.5 and range 5
corStruct = corGaus(form = ~ x + y, nugget = TRUE,
value = c("range" = 5, "nugget" = 0.5))
#Fit the pengls model, for simplicity for a simple lambda
register(MulticoreParam(2)) #Prepare multithereading
penglsFitCV = cv.pengls(data = df, outVar = "a", xNames = grep(names(df),
pattern = "b", value = TRUE),
glsSt = corStruct, nfolds = 5)
penglsFitCV$lambda.1se #Lambda for 1 standard error rule
penglsFitCV$cvOpt #Corresponding R2
coef(penglsFitCV)
penglsFitCV$foldid #The folds used
#With MSE as loss function
penglsFitCVmse = cv.pengls(data = df, outVar = "a",
xNames = grep(names(df), pattern = "b", value =TRUE),
glsSt = corStruct, nfolds = 5, loss = "MSE")
penglsFitCVmse$lambda.1se #Lambda for 1 standard error rule
penglsFitCVmse$cvOpt #Corresponding MSE
coef(penglsFitCVmse)
predict(penglsFitCVmse)
}
