% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTargetFeatureStatistic.R
\name{getTargetFeatureStatistic}
\alias{getTargetFeatureStatistic}
\title{Calculate chromatographic peak properties}
\usage{
getTargetFeatureStatistic(
    fittedCurves,
    targetFeatTable,
    foundPeakTable,
    verbose = FALSE
)
}
\arguments{
\item{fittedCurves}{(list) A list (one entry per ROI window) of
\code{peakPantheR_curveFit} or NA}

\item{targetFeatTable}{a \code{\link{data.frame}} of compounds to target as
rows. Columns: \code{cpdID} (str), \code{cpdName} (str), \code{rtMin} (float
in seconds), \code{rt} (float in seconds, or \emph{NA}), \code{rtMax} (float
in seconds), \code{mzMin} (float), \code{mz} (float or \emph{NA}),
\code{mzMax} (float).}

\item{foundPeakTable}{a \code{data.frame} as generated by
\code{\link{findTargetFeatures}}, with features as rows and peak properties
as columns. The following columns are mandatory: \code{mzMin}, \code{mz},
\code{mzMax}, \code{rtMin}, \code{rt}, \code{rtMax}}

\item{verbose}{(bool) if TRUE message when NA scans are removed}
}
\value{
A \code{data.frame} with measured compounds as rows and measurements
and properties as columns (see Details).

\subsection{Details:}{
The returned \code{data.frame} is structured as follow:
\tabular{ll}{
found \tab was the peak found\cr
rt \tab retention time of peak apex (sec)\cr
rtMin \tab leading edge of peak retention time (sec) determined at 0.5\% of
apex intensity\cr
rtMax \tab trailing edge of peak retention time (sec) determined at 0.5\% of
apex intensity\cr
mz \tab weighted (by intensity) mean of peak m/z across scans\cr
mzMin \tab m/z peak minimum (between rtMin, rtMax)\cr
mzMax \tab m/z peak maximum (between rtMin, rtMax)\cr
peakArea \tab integrated peak area\cr
peakAreaRaw \tab integrated peak area from raw data points\cr
maxIntMeasured \tab maximum peak intensity in raw data\cr
maxIntPredicted \tab maximum peak intensity based on curve fit\cr
ppm_error \tab difference in ppm between the expected and measured m/z\cr
rt_dev_sec \tab difference in seconds between the expected and measured rt\cr
tailingFactor \tab the tailing factor is a measure of peak tailing. It is
defined as the distance from the front slope of the peak to the back slope
divided by twice the distance from the center line of the peak to the front
slope, with all measurements made at 5\% of the maximum peak height. The
tailing factor of a peak will typically be similar to the asymmetry factor
for the same peak, but the two values cannot be directly converted\cr
asymmetryFactor \tab the asymmetry factor is a measure of peak tailing. It is
defined as the distance from the center line of the peak to the back slope
divided by the distance from the center line of the peak to the front slope,
with all measurements made at 10\% of the maximum peak height. The asymmetry
factor of a peak will typically be similar to the tailing factor for the same
peak, but the two values cannot be directly converted\cr
}
}
}
\description{
Calculate the ppm error, retention time deviation, tailing
factor and asymmetry factor for each measured feature.
}
\details{
## Examples cannot be computed as the function is not exported:
# fittedCurve
cFit1 <- list(amplitude=162404.8057918259, center=3341.888,
                sigma=0.078786133031045896, gamma=0.0018336101984172684,
                fitStatus=2, curveModel='skewedGaussian')
class(cFit1) <- 'peakPantheR_curveFit'
cFit2        <- list(amplitude=199249.10572753669, center=3382.577,
                    sigma=0.074904415304607966, gamma=0.0011471899372353885,
                    fitStatus=2, curveModel='skewedGaussian')
class(cFit2)    <- 'peakPantheR_curveFit'
input_fitCurves <- list(cFit1, cFit2)

# ROI
input_ROI <- data.frame(matrix(vector(), 2, 8, dimnames=list(c(), c('cpdID',
                'cpdName', 'rtMin', 'rt', 'rtMax', 'mzMin', 'mz', 'mzMax'))),
                stringsAsFactors=FALSE)
input_ROI[1,] <- c('ID-1', 'testCpd 1', 3310., 3344.88, 3390., 522.19, 522.2,
                    522.21)
input_ROI[2,] <- c('ID-2', 'testCpd 2', 3280., 3385.58, 3440., 496.19, 496.2,
                    496.21)
input_ROI[,3:8] <- vapply(input_ROI[,3:8], as.numeric, FUN.VALUE=numeric(2))

# foundPeakTable
input_foundPeakTable <- data.frame(matrix(vector(), 2, 10, dimnames=list(c(),
                    c('found', 'rtMin', 'rt', 'rtMax', 'mzMin', 'mz',
                    'mzMax','peakArea','maxIntMeasured','maxIntPredicted'))),
                    stringsAsFactors=FALSE)
input_foundPeakTable[1,]  <- c(TRUE, 3309.758, 3346.827, 3385.410, 522.19,
                                522.2, 522.21, 26133726, 889280, 901015)
input_foundPeakTable[2,]  <- c(TRUE, 3345.376, 3386.529, 3428.279, 496.19,
                                496.2, 496.21, 35472141, 1128960, 1113576)
input_foundPeakTable[,1]  <- vapply(input_foundPeakTable[,c(1)], as.logical,
                                FUN.VALUE=logical(1))

# Run peak statistics
peakStatistics <- getTargetFeatureStatistic(input_fitCurves, input_ROI,
                                            input_foundPeakTable)
peakStatistics   
#   found    rtMin       rt    rtMax  mzMin    mz  mzMax peakArea
# 1  TRUE 3309.758 3346.827 3385.410 522.19 522.2 522.21 26133726
# 2  TRUE 3345.376 3386.529 3428.279 496.19 496.2 496.21 35472141
#    maxIntMeasured maxIntPredicted ppm_error rt_dev_sec tailingFactor
# 1          889280          901015         0      1.947      1.015385
# 2         1128960         1113576         0      0.949      1.005372
#    asymmetryFactor
# 1         1.026886
# 2         1.009304
}
