% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combineRegionsHelper.R
\name{crDisjoinFilter}
\alias{crDisjoinFilter}
\title{Separate genomic regions by coverage (disjoin) and filter input regions}
\usage{
crDisjoinFilter(data, foundInSamples)
}
\arguments{
\item{data}{PeakCombiner data frame structure with required columns
named \code{chrom}, \code{start}, \code{end}, \code{name},
\code{score}, \code{strand}, \code{center}, \code{sample_name}. Additional
columns will be dropped}

\item{foundInSamples}{Only include genomic regions that are found
in at least \code{foundInSamples} \strong{number}
of samples. If \code{foundInSamples} is a fraction
between 0 and 1, then only include genomic
regions that ar found in at least
\code{foundInSamples} \strong{fraction} of samples.
Default value is 2.}
}
\value{
A tibble with the following columns: \code{chrom}, \code{start}, \code{end},
\code{width}, \code{strand}, \code{revmap}, \code{ranking_comb_ref}, \code{name}, \code{rowname_disjoin}.
}
\description{
Helper function for main function \link{combineRegions}.
Requires in memory data frame in the standard accepted format for the
peakCombiner package.
For details see the details for \link{combineRegions}.
}
\details{
Retain overlapping genomic regions that are found in at least
\code{foundInSamples} samples. In this way, you can remove rare or
sample-specific regions.
}
