% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/machinelearning-functions-plsda.R
\name{plsdaClassification}
\alias{plsdaClassification}
\alias{plsdaPrediction}
\title{plsda classification}
\usage{
plsdaClassification(
  object,
  assessRes,
  scores = c("prediction", "all", "none"),
  ncomp,
  fcol = "markers",
  ...
)
}
\arguments{
\item{object}{An instance of class \code{"\linkS4class{MSnSet}"}.}

\item{assessRes}{An instance of class
\code{"\linkS4class{GenRegRes}"}, as generated by
\code{\link{plsdaOptimisation}}.}

\item{scores}{One of \code{"prediction"}, \code{"all"} or
\code{"none"} to report the score for the predicted class
only, for all classes or none.}

\item{ncomp}{If \code{assessRes} is missing, a \code{ncomp} must
be provided.}

\item{fcol}{The feature meta-data containing marker definitions.
Default is \code{markers}.}

\item{...}{Additional parameters passed to \code{\link{plsda}}
from package \code{caret}.}
}
\value{
An instance of class \code{"\linkS4class{MSnSet}"} with
    \code{plsda} and \code{plsda.scores} feature variables storing
    the classification results and scores respectively.
}
\description{
Classification using the partial least square
distcriminant analysis algorithm.
}
\examples{
\donttest{
## not running this one for time considerations
library(pRolocdata)
data(dunkley2006)
## reducing parameter search space and iterations 
params <- plsdaOptimisation(dunkley2006, ncomp = c(3, 10),  times = 2)
params
plot(params)
f1Count(params)
levelPlot(params)
getParams(params)
res <- plsdaClassification(dunkley2006, params)
getPredictions(res, fcol = "plsda")
getPredictions(res, fcol = "plsda", t = 0.9)
plot2D(res, fcol = "plsda")
}
}
\author{
Laurent Gatto
}
