% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSnSet.R
\name{orgQuants}
\alias{orgQuants}
\title{Returns organelle-specific quantile scores}
\usage{
orgQuants(object, fcol, scol, mcol = "markers", t, verbose = TRUE)
}
\arguments{
\item{object}{An instance of class \code{"\linkS4class{MSnSet}"}.}

\item{fcol}{The name of the prediction column in the
\code{featureData} slot.}

\item{scol}{The name of the prediction score column in the
\code{featureData} slot. If missing, created by pasting
'.scores' after \code{fcol}.}

\item{mcol}{The name of the column containing the training data in the
\code{featureData} slot. Default is \code{markers}.}

\item{t}{The quantile threshold.}

\item{verbose}{If \code{TRUE}, the calculated threholds are printed.}
}
\value{
A named \code{vector} of organelle thresholds.
}
\description{
This function produces organelle-specific quantiles corresponding to 
the given classification scores.
}
\examples{
library("pRolocdata")
data(dunkley2006)
res <- svmClassification(dunkley2006, fcol = "pd.markers",
                         sigma = 0.1, cost = 0.5)
## 50\% top predictions per class
ts <- orgQuants(res, fcol = "svm", t = .5)
getPredictions(res, fcol = "svm", t = ts)
}
\seealso{
\code{\link{getPredictions}} to get organelle predictions based
on calculated thresholds.
}
\author{
Lisa Breckels
}
