% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queryWithContrasts.R
\name{loadContrastDatabase}
\alias{loadContrastDatabase}
\title{Load contrast database}
\usage{
loadContrastDatabase(
  organism = c("Human", "Mouse"),
  mode = c("ANALYSIS", "DEMO"),
  mustWork = TRUE
)
}
\arguments{
\item{organism}{Character scalar selecting the organism for which to load the
contrast database. One of \code{"Human"} or \code{"Mouse"}.}

\item{mode}{When in "ANALYSIS" mode (default) the complete contrast DB is
queried. "DEMO" mode employs a small "toy" database for the queries.
"DEMO" should only be used for testing/demonstration purposes
and never for actual analysis purposes.}

\item{mustWork}{Logical scalar. If \code{FALSE} and the contrast database
is not available, return an empty \code{SummarizedExperiment} object.
If \code{TRUE} (the default) and the contrast database is
not available, \code{loadContrastDatabase} throws an error.}
}
\value{
A \code{SummarizedExperiment} with pre-calculated contrasts as
    assays.
}
\description{
Load a pre-calculated, organism-specific contrast database and return it
as a \code{SummarizedExperiment}.
}
\details{
Organism-specific databases are compiled in HDF5SummarizedExperiment objects.
The first time `loadContrastDatabase()` is called for 
a database either directly or via `queryWithContrasts()` the required objects 
will be automatically downloaded from `ExperimentHub` and cached in the user
ExperimentHub directory (see `ExperimentHub::getExperimentHubOption("CACHE")`) using the `orthosData` 
companion data-package.
}
\examples{

# !!!Note!!! mode="DEMO" for demonstration purposes only. Default is mode="ANALYSIS"
SE_mouse_demoDB <- loadContrastDatabase (organism="Mouse", mode="DEMO")
SE_mouse_demoDB

SE_human_demoDB <- loadContrastDatabase (organism="Human", mode="DEMO")
SE_human_demoDB


}
\author{
Panagiotis Papasaikas, Michael Stadler
}
