% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module_triselector.R
\name{triselector_module}
\alias{triselector_module}
\title{The three-step selector - the module function}
\usage{
triselector_module(
  input,
  output,
  session,
  reactive_x,
  reactive_selector1 = reactive(NULL),
  reactive_selector2 = reactive(NULL),
  reactive_selector3 = reactive(NULL),
  label = "Group Label:"
)
}
\arguments{
\item{input}{input}

\item{output}{output}

\item{session}{session}

\item{reactive_x}{an nx3 matrix}

\item{reactive_selector1}{default value for selector 1}

\item{reactive_selector2}{default value for selector 2}

\item{reactive_selector3}{default value for selector 3}

\item{label}{of the triselector}
}
\value{
an reactive object containing the selected values
}
\description{
The selector is used to select columns of phenotype and feature data. 
Function should only be used for the developers.
}
\examples{
if (interactive()) {
  library(shiny)
  library(Biobase)
  
  file <- system.file("extdata/demo.RDS", package = "omicsViewer")
  dat <- readRDS(file)
  fData <- fData(dat)
  triset <- stringr::str_split_fixed(colnames(fData), '\\\\|', n= 3)
  
  ui <- fluidPage(
    triselector_ui("tres"),
    triselector_ui("tres2")
  )
  server <- function(input, output, session) {
    v1 <- callModule(triselector_module, id = "tres", reactive_x = reactive(triset),
                     reactive_selector1 = reactive("ttest"),
                     reactive_selector2 = reactive("RE_vs_ME"),
                     reactive_selector3 = reactive("mean.diff")
    )
    v2 <- callModule(triselector_module, id = "tres2", reactive_x = reactive(triset),
                     reactive_selector1 = reactive("ttest"),
                     reactive_selector2 = reactive("RE_vs_ME"),
                     reactive_selector3 = reactive("log.fdr"))
    observe({
      print("/////////////////////////")
      print(v1())
    })
  }
  
  shinyApp(ui, server)
}
}
