% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proc_funs.R
\name{removeVarQC}
\alias{removeVarQC}
\title{Removing variance of reference samples}
\usage{
removeVarQC(x, ref, positive = TRUE, ...)
}
\arguments{
\item{x}{an expression matrix}

\item{ref}{the index of reference samples}

\item{positive}{logical; force only positive values in the resulted matrix}

\item{...}{if given, \code{\link{normalize.nQuantiles}} will be called first, 
the arguments here will be passed to \code{\link{normalize.nQuantiles}}}
}
\value{
a normalized matrix
}
\description{
This normalization removes the variance in reference samples. The 
  method do not need to specific the batch assignment but cannot work with data
  contains less than five common reference samples. A typical use of this normalization
  is to correct some drifting effect in mass spec based label free proteomics or 
  untargeted metabolomics experiment. Usually, this is a very strong normalization 
  should only be used with good reasons.
}
\examples{
e1 <- matrix(rnorm(5000), 100, 50)+10
e2 <- removeVarQC(x = e1, ref = seq(5, 45, by = 10))
boxplot(e2)
}
