% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_export_prepEsetViewer.R
\name{prepOmicsViewer}
\alias{prepOmicsViewer}
\title{Prepare object to be viewed by omicsViewer}
\usage{
prepOmicsViewer(
  expr,
  pData,
  fData,
  PCA = TRUE,
  ncomp = min(8, ncol(expr)),
  pca.fillNA = TRUE,
  t.test = NULL,
  ttest.fillNA = FALSE,
  ...,
  gs = NULL,
  stringDB = NULL,
  surv = NULL,
  SummarizedExperiment = TRUE
)
}
\arguments{
\item{expr}{expression matrix where the rows are feature and columns are samples, 
matrix should be log10 transformed and have unique row and column names}

\item{pData}{phenotype data}

\item{fData}{feature data}

\item{PCA}{pca}

\item{ncomp}{number of components to keep}

\item{pca.fillNA}{logical, whether the NA should be filled with a constant in PCA.}

\item{t.test}{will be passed to the \code{compare} argument in \code{\link{multi.t.test}}}

\item{ttest.fillNA}{logical, whether the NA should be filled with a constant in t-test.}

\item{...}{arguments passed to \code{\link{t.test}}, such as \code{paired}.}

\item{gs}{gene-set data, please refer to examples for more details about the format}

\item{stringDB}{the IDs that can be used in the STRING database (https://string-db.org/) query.}

\item{surv}{survival data, please refer to examples for more details about the format}

\item{SummarizedExperiment}{logical; whether to return an object of class \code{SummarizedExperiment}. 
If set to FALSE, the function will return an \code{ExpressionSet} object.}
}
\value{
an object of \code{ExpressionSet} or \code{SummarizedExperiment} that can be visualized using
\code{omicsViewer}
}
\description{
This is a convenience function to prepare the data to be visualized using \code{\link{omicsViewer}}.
  The result of PCA and t-test could be included directly.
}
\examples{
packdir <- system.file("extdata", package = "omicsViewer")
# reading expression
expr <- read.delim(file.path(packdir, "expressionMatrix.tsv"), stringsAsFactors = FALSE)
colnames(expr) <- make.names(colnames(expr))
rownames(expr) <- make.names(rownames(expr))
# reading feature data
fd <- read.delim(file.path(packdir, "featureGeneral.tsv"), stringsAsFactors = FALSE)
# reading phenotype data
pd <- read.delim(file.path(packdir, "sampleGeneral.tsv"), stringsAsFactors = FALSE)

#  reading other datasets
drugData <- read.delim(file.path(packdir, "sampleDrug.tsv"))
# survival data
# this data is from cell line, the survival data are fake data to 
# show how to use the survival data in #' omicsViewer
surv <- read.delim(file.path(packdir, "sampleSurv.tsv"))
# gene set information
genesets <- read_gmt(file.path(packdir, "geneset.gmt"), data.frame = TRUE)
gsannot <- gsAnnotIdList(idList = rownames(fd), gsIdMap = genesets, data.frame = TRUE)

# Define t-test to be done, a matrix nx3
# every row define a t-test, the format
# [column header] [group 1 in the test] [group 2 in the test]
tests <- rbind(
 c("Origin", "RE", "ME"),
 c("Origin", "RE", "LE"),
 c('TP53.Status', "MT", "WT")
 )
# prepare column for stringDB query
strid <- sapply(strsplit(fd$Protein.ID, ";|-"), "[", 1)
###
d <- prepOmicsViewer(
  expr = expr, pData = pd, fData = fd, 
  PCA = TRUE, pca.fillNA = TRUE,
  t.test = tests, ttest.fillNA = FALSE, 
  gs = gsannot, stringDB = strid, surv = surv)
# feature space - default x axis
attr(d, "fx") <- "ttest|RE_vs_ME|mean.diff"
# feature space - default y axis
attr(d, "fy") <- "ttest|RE_vs_ME|log.fdr"
# sample space - default x axis
attr(d, "sx") <- "PCA|All|PC1("
# sample space - default y axis
attr(d, "sy") <- "PCA|All|PC2("
# Save object and view
# saveRDS(d, file = "dtest.RDS")
##  to open the viewer
# omicsViewer("./")
}
