% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{perform_correlation_tests}
\alias{perform_correlation_tests}
\title{Correlation test}
\usage{
perform_correlation_tests(
  object,
  x,
  y = x,
  id = NULL,
  object2 = NULL,
  fdr = TRUE,
  all_pairs = TRUE,
  duplicates = FALSE,
  assay.type1 = NULL,
  assay.type2 = NULL,
  ...
)
}
\arguments{
\item{object}{a \code{
\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object}

\item{x}{character vector, names of variables to be correlated}

\item{y}{character vector, either identical to x (the default) or a distinct 
set of variables to be correlated against x}

\item{id}{character, column name for subject IDs. If provided, the 
correlation will be computed using the rmcorr package}

\item{object2}{optional second object. If provided, x 
variables will be taken from object and y variables will be taken from 
object2. Both objects should have the same number of samples.}

\item{fdr}{logical, whether p-values from the correlation test should be 
adjusted with FDR correction}

\item{all_pairs}{logical, whether all pairs between x and y should be tested.
If FALSE, x and y give the exact pairs of variables to test, and should have 
the same length.}

\item{duplicates}{logical, whether correlations should be duplicated. If 
\code{TRUE}, each correlation will be included in the results twice, where 
the order of the variables '(which is x and which is y) is changed. Can be 
useful for e.g. plotting a heatmap of the results, see examples of
\code{\link[notameViz]{plot_effect_heatmap}}.}

\item{assay.type1}{character, assay of object(1) to be used in case of 
multiple assays}

\item{assay.type2}{character, assay of object2 to be used in case of 
multiple assays}

\item{...}{other parameters passed to \code{\link{cor.test}}, such as method}
}
\value{
A data frame with the results of correlation tests: the pair of 
variables, correlation coefficient and p-value.
}
\description{
Performs a correlation test between two sets of variables. All the variables 
must be either feature names or column names of pheno data (sample 
information).
There are two ways to use this function:
either provide a set of variables as \code{x}, and all correlations between
those variables are computed. Or provide two distinct sets of variables 
\code{x, y} and correlations between each x variable
and each y variable are computed.
}
\examples{
data(toy_notame_set, package = "notame")
# Correlations between all features
correlations <- perform_correlation_tests(toy_notame_set, 
  x = rownames(toy_notame_set), id = "Subject_ID")

# Spearman Correlations between features and sample information variables
# Drop QCs and convert time to numeric
no_qc <- notame::drop_qcs(toy_notame_set)
no_qc$Time <- as.numeric(no_qc$Time)
correlations <- perform_correlation_tests(no_qc,
  x = rownames(toy_notame_set),
  y = c("Time", "Injection_order"), method = "spearman"
)

# Correlations between variables from two distinct objects
cross_object_cor <-perform_correlation_tests(toy_notame_set,
  x = rownames(toy_notame_set),
  object2 = toy_notame_set,
  y = rownames(toy_notame_set),
  all_pairs = FALSE
)
}
\seealso{
\code{\link{cor.test}}, \code{\link[rmcorr]{rmcorr}}
}
