% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/getBaselineDivergence.R
\name{getBaselineDivergence}
\alias{getBaselineDivergence}
\alias{addBaselineDivergence}
\alias{getBaselineDivergence,SummarizedExperiment-method}
\alias{addBaselineDivergence,SummarizedExperiment-method}
\title{Beta diversity between the baseline and later time steps}
\usage{
getBaselineDivergence(x, ...)

addBaselineDivergence(x, ...)

\S4method{getBaselineDivergence}{SummarizedExperiment}(
  x,
  time.col,
  assay.type = "counts",
  reference = NULL,
  group = NULL,
  method = "bray",
  ...
)

\S4method{addBaselineDivergence}{SummarizedExperiment}(
  x,
  name = c("divergence", "time_diff", "ref_samples"),
  ...
)
}
\arguments{
\item{x}{A
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object.}

\item{...}{Optional arguments passed into
\code{\link[mia:addDivergence]{mia::addDivergence()}}.}

\item{time.col}{\code{Character scalar}. Specifies a name of the column from
\code{colData} that identifies the sampling time points for the samples.}

\item{assay.type}{\code{Character scalar}. Specifies which assay values are
used in the dissimilarity estimation. (Default: \code{"counts"})}

\item{reference}{\code{Character scalar}. Specifies a name of the column from
\code{colData} that identifies the baseline samples to be used.
(Default: \code{NULL})}

\item{group}{\code{Character scalar}. Specifies a name of the column from
\code{colData} that identifies the grouping of the samples.
(Default: \code{NULL})}

\item{method}{\code{Character scalar}. Used to calculate the dissimilarity
Method is passed to the function that is specified by \code{dis.fun}.
(Default: \code{"bray"})}

\item{name}{\code{Character vector}. Specifies a column name for storing
divergence results.
(Default: \code{c("divergence", "time_diff", "ref_samples")})}
}
\value{
\code{getBaselineDivergence} returns \code{DataFrame} object
containing the sample dissimilarity and corresponding time difference between
samples. \code{addBaselineDivergence}, on the other hand, returns a
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object with these results in its \code{colData}.
}
\description{
Calculates sample dissimilarity between the given baseline and other
time points, optionally within a group (subject, reaction chamber, or
similar). The corresponding time difference is returned as well.
}
\details{
The group argument allows calculating divergence per group. If given, the
divergence is calculated per group.  e.g. subject, chamber, group etc.
Otherwise, this is done across all samples at once.

The baseline sample(s) always need to belong to the data object i.e. they
can be merged into it before
applying this function. The reason is that they need to have comparable
sample data, at least some time point
information for calculating time differences w.r.t. baseline sample.

The baseline time point is by default defined as the smallest time point
(per group). Alternatively,
the user can provide the baseline vector, or a list of baseline vectors per
group (named list per group).
}
\examples{
library(miaTime)

data(hitchip1006)
tse <- transformAssay(hitchip1006, method = "relabundance")

# By default, reference samples are the samples from the first timepoint
tse <- addBaselineDivergence(
    tse,
    group = "subject",
    time.col = "time",
    assay.type = "relabundance",
    method = "bray")

# Add reference samples to colData, if you want to specify reference
# samples manually
colData(tse)[["reference"]] <- "Sample-875"
tse <- addBaselineDivergence(
    tse,
    reference = "reference",
    group = "subject",
    time.col = "time",
    name = c("divergence_from_baseline",
        "time_from_baseline", "reference_samples"),
    assay.type = "relabundance",
    method = "bray")

}
\seealso{
\code{\link[mia:addDivergence]{mia::addDivergence()}}
}
