\name{diagplotBoxplot}
\alias{diagplotBoxplot}
\title{Boxplots wrapper for the metaseqR2 package}
\usage{
    diagplotBoxplot(mat, name = NULL, logIt = "auto",
        yLim = "default", isNorm = FALSE, output = "x11",
        path = NULL, altNames = NULL, ...)
}
\arguments{
    \item{mat}{the count data matrix.}

    \item{name}{the names of the samples plotted on the
    boxplot. See also Details.}

    \item{logIt}{whether to log transform the values of mat
    or not. It can be \code{TRUE}, \code{FALSE} or
    \code{"auto"} for auto-detection. Auto-detection log
    transforms by default so that the boxplots are smooth and
    visible.}

    \item{yLim}{custom y-axis limits. Leave the string
    \code{"default"} for default behavior.}

    \item{isNorm}{a logical indicating whether object
    contains raw or normalized data. It is not essential and
    it serves only plot annotation purposes.}

    \item{output}{one or more R plotting device to direct the
    plot result to. Supported mechanisms: \code{"x11"}
    (default), \code{"png"}, \code{"jpg"}, \code{"bmp"},
    \code{"pdf"}, \code{"ps"} or \code{"json"}. The latter is
    currently available for the creation of interactive
    volcano plots only when reporting the output, through the
    highcharts javascript library (JSON for boxplots not yet
    available).}

    \item{path}{the path to create output files.}
    
    \item{altNames}{an optional vector of names, e.g. HUGO
    gene symbols, alternative or complementary to the unique
    rownames of \code{mat} (which must exist!). It is used only 
    in JSON output.}

    \item{...}{further arguments to be passed to plot
    devices, such as parameter from \code{\link{par}}.}
}
\value{
    The filename of the boxplot produced if it's a file.
}
\description{
    A wrapper over the general boxplot function, suitable for
    matrices produced and processed with the metaseqr
    package. Intended for internal use but can be easily used
    as stand-alone. It can colors boxes based on group
    depending on the name argument.
}
\details{
    Regarding \code{name}, if \code{NULL}, the function check 
    the column names of \code{mat}. If they are also 
    \code{NULL}, sample names are autogenerated. If 
    \code{name="none"}, no sample names are plotted. If name 
    is a list, it should be the sampleList argument provided 
    to the manin metaseqr2 function. In that case, the boxes  
    are colored per group.
}
\examples{
# Non-normalized boxplot
require(DESeq2)
dataMatrix <- metaseqR2:::exampleCountData(2000)
sampleList <- list(A=c("A1","A2"),B=c("B1","B2","B3"))
diagplotBoxplot(dataMatrix,sampleList)

# Normalized boxplot
normArgs <- getDefaults("normalization","deseq2")
object <- normalizeDeseq2(dataMatrix,sampleList,normArgs)
diagplotBoxplot(object,sampleList)
}
\author{
    Panagiotis Moulos
}
