% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportOverlaps.R
\name{exportOverlaps}
\alias{exportOverlaps}
\title{Export Overlap Groups to Excel}
\usage{
exportOverlaps(
  grouped,
  output_dir = ".",
  output_file = "overlap_groups",
  with_date = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{grouped}{Overlap groups from \code{extractOverlaps()}.}

\item{output_dir}{A string specifying the output directory. Defaults to \code{"."}.}

\item{output_file}{A string specifying the base filename (without extension).
Defaults to \code{"overlap_groups"}.}

\item{with_date}{Logical (default \code{TRUE}). Whether to prepend the current
date (from \code{today}) to the filename.}

\item{verbose}{Logical. If \code{TRUE}, print a message with the saved path.
Default \code{TRUE}.}
}
\value{
Overlap groups are saved to a Excel file on disk. Invisibly returns
the full path to the saved file.
}
\description{
This function exports the output of \code{extractOverlaps()} to an Excel file,
creating one sheet per overlap group. Genomic overlaps (\code{GRanges}) are
converted to data frames before export.
}
\examples{
res <- computeOverlaps(list(A = letters[1:3], B = letters[2:4]))
grouped <- extractOverlaps(res)
exportOverlaps(grouped, output_dir = tempdir(), output_file = "overlap_groups")
}
