% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardize_MAE.R
\name{set_unique_cl_names}
\alias{set_unique_cl_names}
\title{Set Unique Parental Identifiers}
\usage{
set_unique_cl_names(se)
}
\arguments{
\item{se}{A SummarizedExperiment object.}
}
\value{
A SummarizedExperiment object with unique \code{CellLineName} in \code{colData}.
}
\description{
This function sets the \code{CellLineName} field in
\code{colData} to be unique by appending the \code{clid} in parentheses for duplicates.
}
\examples{
se <- SummarizedExperiment::SummarizedExperiment(
  assays = list(counts = matrix(1:4, ncol = 2)),
  colData = S4Vectors::DataFrame(CellLineName = c("ID1", "ID1"), clid = c("C1", "C2"))
)
se <- set_unique_cl_names(se)
}
\keyword{standardize_MAE}
