% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fgsea.R
\name{fgsea}
\alias{fgsea}
\title{Wrapper to run methods for preranked gene set enrichment analysis.}
\usage{
fgsea(
  pathways,
  stats,
  minSize = 1,
  maxSize = length(stats) - 1,
  gseaParam = 1,
  ...
)
}
\arguments{
\item{pathways}{List of gene sets to check.}

\item{stats}{Named vector of gene-level stats. Names should be the same as in 'pathways'}

\item{minSize}{Minimal size of a gene set to test. All pathways below the threshold are excluded.}

\item{maxSize}{Maximal size of a gene set to test. All pathways above the threshold are excluded.}

\item{gseaParam}{GSEA parameter value, all gene-level statis are raised to the power of `gseaParam`}

\item{...}{optional arguments for functions \link[fgsea]{fgseaSimple}, \link[fgsea]{fgseaMultilevel}}
}
\value{
A table with GSEA results. Each row corresponds to a tested pathway.
}
\description{
This function provide an interface to two existing functions:
\link[fgsea]{fgseaSimple}, \link[fgsea]{fgseaMultilevel}.
By default, the \link[fgsea]{fgseaMultilevel} function is used for analysis.
For compatibility with the previous implementation you can pass the `nperm` argument to the function.
}
\examples{
data(examplePathways)
data(exampleRanks)
fgseaRes <- fgsea(examplePathways, exampleRanks, maxSize=500)
# Testing only one pathway is implemented in a more efficient manner
fgseaRes1 <- fgsea(examplePathways[1], exampleRanks)
}
